#ifndef ROBOTBICYCLECONST_H_INCLUDED
#define ROBOTBICYCLECONST_H_INCLUDED

#define R_wheel 0.0695f  ///radius of wheels
#define l_rs    0.095f   ///length from rear wheel to sensor on XY plane
#define l_rg    0.13f    ///length from rear wheel to center of mass on XY plane
#define h       0.2f     ///height of center of mass
#define Omega_l 8.78337f ///244*pi*33/24/24/5
#define Omega_m 14.639f  ///244*pi*33/24/24/3
#define Omega_h 21.958f  ///244*pi*33/24/24/2
#define v_low   1.0174f  ///starting speed of bicycle (m/s) v = 2pi/(48*3/244)*(33/24)*R_wheel
#define v_high  1.5261f  ///full speed of bicycle (m/s) v = 2pi/(48*2/244)*(33/24)*R_wheel

#define b_h     31.3196f ///23.4897 ///v^2*cos_delta/L/l_virtual ///0.0491*Omega^2 - 0.245
#define c_h     2.0009f  ///2.6679  ///l_rg*v*cos_delta/L/l_virtual  ///0.00281*Omega
#define bc_h    b_h/c_h

#define b_m     10.4399f
#define c_m     1.334f
#define bc_m    b_m/c_m

#define b_l     3.7584f
#define c_l     0.8004f
#define bc_l    b_l/c_l

#endif // ROBOTBICYCLECONST_H_INCLUDED
