/*
function generator
Curtis Mattull
10/14/16
*/
#include "mbed.h"
#include "arm_math.h"
#include "arm_const_structs.h"
#include "my_LUT.h"

void inc_func(void);
void inc_freq(void);

AnalogOut vout(DAC0_OUT);
Serial pc(USBTX,USBRX);

InterruptIn sw2(SW2);
InterruptIn sw3(SW3);


const int num_pts = 128;
double desired_freq = 60;    //60 Hz
int func = 0;
double dt = (1/desired_freq)/num_pts; // 1/60 = 0.0167, dt = 0.0167/num_pts
const double dac_write_delay = 0.000009;
double sample_delay = dt-dac_write_delay;

int main(void)
{
    pc.baud(115200);   
    pc.printf("start\r\n");

    int i =0;
    double amplitude = 0.5;
//    static float write_dac_time = 0;
//    static Timer    timer;
//    static float    begin = 0,
//                    end = 0;
    sw2.rise(&inc_func);
    sw3.rise(&inc_freq);

//    timer.start();
//    begin = timer.read_us();
//    vout.write(amplitude+.5*LUT[func][i*(int)(512/num_pts)]);
//    timer.stop();
//    end = timer.read_us();   //trigger_end
//    write_dac_time = end-begin;
//    
//    pc.printf("dac write time[us]: %f", write_dac_time);
//    wait(1);

    while(1) {
        /*populate some dummy sin data*/
        for(i = 0; i< num_pts; i++)
        {//dac write time was determined to be 8us
            vout.write(amplitude+.5*LUT[func][i*(int)(512/num_pts)]);
            wait(sample_delay);
        }
    }
}

void inc_func(void)
{
    func++;
    if (func==3)
    {
        func = 0;
    }
}

void inc_freq(void)
{
    desired_freq++;
    if (desired_freq>200)
    {
        desired_freq =1;
    }
    dt = (1/desired_freq)/num_pts; // 1/60 = 0.0167, dt = 0.0167/num_pts
    sample_delay = dt-dac_write_delay;

}
