// Print messages when the AnalogIn is greater than 50%
 
#include "mbed.h"
#include "arm_math.h"
#include "arm_const_structs.h"


#define led_on  0x00
#define led_off 0x01

DigitalOut led_r(PTA1);
DigitalOut led_g(PTA2);
DigitalOut led_b(PTD5);

const int FFT_LEN   = 1024;
const int bins      = 32;


const static arm_cfft_instance_f32 *S;

float samples[FFT_LEN*2];
float magnitudes[FFT_LEN];
float freq_window[bins];


int main() 
{   //initialize led to all off
    led_r.write(led_off);
    led_g.write(led_off);
    led_b.write(led_off);  
    
    
    int32_t i = 0;
    printf("\r\n\r\nFFT test program!\r\n");
    printf("by Curtis Mattull\r\n\r\n\r\n");


        // Init arm_ccft_32
    switch (FFT_LEN)
    {
    case 16:
        S = & arm_cfft_sR_f32_len16;
        break;
    case 32:
        S = & arm_cfft_sR_f32_len32;
        break;
    case 64:
        S = & arm_cfft_sR_f32_len64;
        break;
    case 128:
        S = & arm_cfft_sR_f32_len128;
        break;
    case 256:
        S = & arm_cfft_sR_f32_len256;
        break;
    case 512:
        S = & arm_cfft_sR_f32_len512;
        break;
    case 1024:
        S = & arm_cfft_sR_f32_len1024;
        break;
    case 2048:
        S = & arm_cfft_sR_f32_len2048;
        break;
    case 4096:
        S = & arm_cfft_sR_f32_len4096;
        break;
    }

    /*populate some dummy sin data*/
    for(i = 0; i< FFT_LEN*2; i+=2)
    {
        //fast math sine table[512+1]
        samples[i]      = sinTable_f32[i/4];
        samples[i+1]    = 0;
    }
    
    /*multiply the dummy data with more dummy data*/
//    for(i = 0; i< FFT_LEN*2; i+=2)
//    {
//        //fast math sine table[512+1]
//        samples[i]     +=sinTable_f32[i/2] ;
//        samples[i+1]    = 0;
//    }
    
    // Run FFT on sample data.
    arm_cfft_f32(S, samples, 0, 1);
    // Calculate magnitude of complex numbers output by the FFT.
    arm_cmplx_mag_f32(samples, magnitudes, FFT_LEN);
    
    printf("\r\nThe first 20 bins:\r\n");
    
    for(i = 0; i< 20; i++)
    {
        printf("magnitudes[%i]: %f\r\n",i,magnitudes[i]);
    }
    
    led_g.write(led_on);

    printf("test complete\r\n");
    wait(1);
    while(1) 
    {
        
    }
}