/*  Curtis Mattull
    10/1/16
    This simple program tests LCD SPI functionality
*/
#include "mbed.h"
#include "FT_Platform.h"

void    screen1(uint32_t tracker, uint8_t tag);
void    rotate_screen(uint8_t val);
// create an LCD object
FT800 TFT( PTD6, PTD7, PTD5, PTD4, PTB19, PTA1);
//       ( mosi, miso, sclk,   ss,  intr,  pd );
RawSerial terminal(USBTX, USBRX);    // computer to mbed board
int main(void)
{
    terminal.baud(9600);
    printf("main entered\r\n");
    rotate_screen(1);
    set_time(0);  // Set RTC time to 0
    
    //draw screen
    for(;;)
    {
//        screen1(0x0,0x0);
        wait(1);
    }
 
    return 0;
}


void rotate_screen(uint8_t val)
{
    if (val == 0)
    {
        TFT.MemWrite(REG_ROTATE, 1);    // rotate screen
        TFT.Rotate(1);
        TFT.Flush_Co_Buffer();          // Download the command list into fifo
        TFT.WaitCmdfifo_empty();        // Wait till coprocessor completes the operation
    }
}


void screen1(uint32_t tracker, uint8_t tag)
{
    printf("screen1 entered\r\n");
    time_t seconds = time(NULL);

    //start new display list
    TFT.DLstart();                                                      // start a new display command list
    TFT.DL(CLEAR_COLOR_RGB(255,255,255));                               // set the clear color to white
    TFT.DL(CLEAR(1,1,1));                                               // clear buffers -> color buffer,stencil buffer, tag buffer

    TFT.DL(TAG(0));                         // assign TAG value 0 to everything else

    //title text
    TFT.DL(COLOR_RGB(0, 0, 0));
    TFT.Text((TFT.DispWidth/2), TFT.DispHeight/8, 28, OPT_CENTERX, "test\0");        // draw Text with font 31

    // time
    TFT.Text((TFT.DispWidth/4), TFT.DispHeight*7/8, 28, OPT_CENTERX, "Run time [s]: \0");        // draw Text with font 31
    TFT.Number((TFT.DispWidth/2), (TFT.DispHeight*7/8),28,OPT_CENTERX, seconds);

    //author text
    TFT.DL(COLOR_RGB(0x00,  0x00,   0x00));
    TFT.Text((TFT.DispWidth*7/8)+9, (TFT.DispHeight*15/16), 28, OPT_CENTERX, "by Curtis Mattull\0");            // draw Text with font 31

    //display the screen
    TFT.DL(DISPLAY());                     // display the image
    TFT.Swap();                            // swap the current display list
    TFT.Flush_Co_Buffer();                 // download the command list into fifo
    TFT.WaitCmdfifo_empty();               // wait till coprocessor completes the operation

}