//
// File: main.cpp
//
// Code generated for Simulink model 'neural_network3'.
//
// Model version                  : 1.7
// Simulink Coder version         : 8.10 (R2016a) 10-Feb-2016
// C/C++ source code generated on : Tue Oct 04 18:06:54 2016
//
// Target selection: ert.tlc
// Embedded hardware selection: ARM Compatible->ARM Cortex
// Code generation objectives: Unspecified
// Validation result: Not run

//#include <stddef.h>
//#include <stdio.h>                     // This ert_main.c example uses printf/fflush 
#include "neural_network_3ph.h"           // Model's header file
#include "rtwtypes.h"
#include "mbed.h"
#include "arm_math.h"
#include "arm_const_structs.h"

#define led_on  0x00
#define led_off 0x01

DigitalOut led_r(PTB22);
DigitalOut led_g(PTE26);
DigitalOut led_b(PTB21);

const int FFT_LEN   = 1024;
const static arm_cfft_instance_f32 *S;
float samples[FFT_LEN*2];
float samples_normalized[FFT_LEN*2];
real_T samples_trimmed[61];
float magnitudes[FFT_LEN];
const float dt = 0.001; // sample rate of 1kHz, letting us analyze signals up to 500Hz
const float acquire_delay = 0.00004;
const float sample_delay = dt-acquire_delay;

AnalogIn adc_in(PTB2);

void init_fft(int FFT_LEN);

void rt_OneStep(void);
void rt_OneStep(void)
{
    static int32_t i = 0;

    // '<Root>/Out1'
    static real_T arg_Out1[2];

    static real_T max = 0;
    static real_T min = 0;
    const float running_thresh = 0.76;
    
    //collect imag data in complex form
    for(i = 0; i< (FFT_LEN*2)+1; i+=2)
    {   
        samples[i+1]    = 0.0;                    // imaginary data
    }
    
    //collect real data in complex form 
    for(i = 0; i< (FFT_LEN*2)+1; i+=2)
    {   
        samples[i]      = adc_in.read();   // real data
        wait(sample_delay); //timestep -40us for reading and storing value
//        wait(dt);
    }
            
    //find max
    for(i = 0; i< (FFT_LEN*2)+1; i+=2)
    {
        if (samples[i] > max)
        {
            max = samples[i];
        }
    } 
 
    //find min
    for(i = 0; i< (FFT_LEN*2)+1; i+=2)
    {
        if (samples[i] < min)
        {
            min = samples[i];
        }
    }       
    
    //normalize data
    for(i = 0; i< (FFT_LEN*2)+1; i+=2)
    {   
        samples_normalized[i]      = (samples[i]-min) / (max - min);   // real data
        samples_normalized[i+1]    = 0.0;                    // imaginary data
    }    
    
    // Calculate complex FFT
    arm_cfft_f32(S, samples_normalized, 0, 1);
    
    // Calculate magnitude of complex numbers output by the FFT.
    arm_cmplx_mag_f32(samples_normalized, magnitudes, FFT_LEN);

//    /*20 - 80 Hz  */ 
    for(i = 0; i< 61; i++)
    {
        samples_trimmed[i] = magnitudes[i+20];
    }
     
    //    /* gain, tweaking lead to 17.5 */ 
    for(i = 0; i< 61; i++)
    {
        samples_trimmed[i] = samples_trimmed[i]*17.5;
    }
    
    // Step the model
    neural_network_custom(samples_trimmed, arg_Out1);
    
    // for debugging, print the input to the neural network
    for(i =0;i<61;i++)
    {
        printf("%i \t %f\r\n",i+20, samples_trimmed[i]);
    }
    
    //print the output of the neural network
    for(i =0;i<2;i++)
    {
        printf("output[%i]: %i",i,(int)arg_Out1[i]);
        printf("\t");
    }
    
    // this was used to determine when the motor was running or not
    printf("\r\n\r\nsample[0]: %f \r\n",samples[0]);

//     output logic controlling leds
    if(arg_Out1[0] == 0)   
    {
        if (arg_Out1[1] == 0)   // 00   normal mode
        {                       // green
            led_r.write(led_off);
            led_g.write(led_on);
            led_b.write(led_off);
        }
        else if(arg_Out1[1] == 1)   // 01 short circuit fault
        {                           // red
            led_r.write(led_on);
            led_g.write(led_off);
            led_b.write(led_off);
        } 
    }
    if(arg_Out1[0] == 1)        
    {
        if (arg_Out1[1] == 1)   // 11   open circuit fault
        {                       // yellow
            led_r.write(led_on);
            led_g.write(led_on);
            led_b.write(led_off);
        }
    }
    
    if(samples[0] < running_thresh) // essentially not running
    {                               // led off
        led_r.write(led_off);
        led_g.write(led_off);
        led_b.write(led_off);
    }
    //end of function
}

void init_fft(int FFT_LEN)
{
    switch (FFT_LEN)
    {
    case 16:
        S = & arm_cfft_sR_f32_len16;
        break;
    case 32:
        S = & arm_cfft_sR_f32_len32;
        break;
    case 64:
        S = & arm_cfft_sR_f32_len64;
        break;
    case 128:
        S = & arm_cfft_sR_f32_len128;
        break;
    case 256:
        S = & arm_cfft_sR_f32_len256;
        break;
    case 512:
        S = & arm_cfft_sR_f32_len512;
        break;
    case 1024:
        S = & arm_cfft_sR_f32_len1024;
        break;
    case 2048:
        S = & arm_cfft_sR_f32_len2048;
        break;
    case 4096:
        S = & arm_cfft_sR_f32_len4096;
        break;
    }
}

int main(void)
{   
    //initialize leds
    led_r.write(led_off);
    led_g.write(led_off);
    led_b.write(led_off);
    
    init_fft(FFT_LEN);
    
    //software process defined within rt_onestep()
    for(;;)
    {
        rt_OneStep();
        printf("run success!!\r\n");
        wait(1);
    }

    return 0;
}