
#include "mbed.h"

#include "ADCInput.h"
#include "CMSerial.h"
#include "DeviceProperties.h"
#include "FullBridgeDriver.h"
#include "MillisecondCounter.h"
#include "PowerController.h"
#include "SPIDAC.h"


DigitalOut myled(LED1);






int main() {    
    InitializeMillisecondCounter();
    SPIDACInitialize();

    ADC.Initialize();

    CMSerial serial;
    PowerController powerController;
    
    for(;;) {        
        // update our status
        Device.SetActualPWMFrequency(PWM.GetActualFrequency());
        
        // pause
        myled = (GetMillisecondCount() / 1000) & 1;
        rtos::Thread::wait(100);
    }
}



