
#include "mbed.h"
#include "SPIDAC.h"


DigitalOut spiChipSelect(p8, 1);    
spi_t spi;


void SPIDACInitialize(void)
{
    // initialize
    spi_init(&spi, p5, p6, p7, NC);    
    spi_format(&spi, 8, 2, 0);
    spi_frequency(&spi, 100000);
    
    // set initial values
    SPIDACSend(0, 0);
}


void SPIDACSend(uint16_t aValue, uint16_t bValue)
{
    // write to B
    spiChipSelect = 0;
    spi_master_write(&spi, 0x10 | (bValue>>6));
    spi_master_write(&spi, bValue<<2);
    while (spi_busy(&spi))
        continue;
    spiChipSelect = 1;

    // pause
    rtos::Thread::wait(1);

    // write to A
    spiChipSelect = 0;
    spi_master_write(&spi, 0x90 | (aValue>>6));
    spi_master_write(&spi, aValue<<2);
    while (spi_busy(&spi))
        continue;
    spiChipSelect = 1;
}

