
#ifndef POWERCONTROLLER_H
#define POWERCONTROLLER_H

#include "Thread.h"

#include "Atomic.h"
#include "IOControl.h"
#include "PID.h"

class PowerController
{
public:
    PowerController(void);

private:
    void AcquireData(void);
    void ExecuteConstantPower(void);
    void ExecuteConstantVoltage(void);
    void ExecuteRamp(void);
    void ProcessPID(void);
    void ThreadEntry(void);
    
private:
    DigitalOut led;
    IOControl ioControl;
    DeviceConfig deviceConfig;
    PID pid;
    int acquisitionTimestamp;
    Atomic<float> outputTarget;
    
    rtos::Thread thread;
    rtos::RtosTimer acquisitionTimer;
    rtos::RtosTimer pidTimer;
};


#endif


