
#ifndef PID_H
#define PID_H


class PID
{
public:
    PID(void);

    void AddSample(double sampleValue);
    double GetOutput(void) { return currentOutput; }
    void Reset(void);
    void SetOutputRange(double minOutput, double maxOutput);
    void SetPeriodMilliseconds(double period) { msPeriod = period; }
    void SetPID(double kp, double ki, double kd);
    void SetTarget(double target) { this->target = target; }
    
private:
    double minOutput, maxOutput;
    double kp, ki, kd;
    double errorIntegral;
    double lastError;
    double msPeriod;
    double target;
    double currentOutput;
};


#endif

