
#include "mbed.h"
#include "Atomic.h"
#include "MillisecondCounter.h"


static void CountMilliseconds(void const *arg);

static Atomic<unsigned> milliseconds;
static rtos::RtosTimer millisecondTimer(&CountMilliseconds);


void InitializeMillisecondCounter(void)
{
    millisecondTimer.start(1);
}

unsigned GetMillisecondCount(void)
{
    return milliseconds.Get();
}


static void CountMilliseconds(void const *arg)
{
    milliseconds.Set(milliseconds.Get() + 1);
}

