
#ifndef IOCONTROL_H
#define IOCONTROL_H

#include "mbed.h"

const double MAX_TARGET_POWER = 200;
const double MAX_OUTPUT_VOLTAGE = 165;

class IOControl
{
public:
    IOControl(void);

    bool ActivateRequested(void);
    void Deactivate(void);
    double GetOutputVoltage(void);
    void SetOutputVoltage(double outputVoltage);
    DeactivateSource GetDeactivationSource(void) { return deactivateSource; }
    
private:
    void TimerEntry(void);
    void UpdateState(void);
    
private:
    enum ActivateState {
        Inactive,
        Activating,
        PoweringUp,
        Active,
        Deactivating,
        Deactivated
    };
    
private:
    DigitalOut hvEn;
    DigitalOut shutdown;
    DigitalIn activate;
    DigitalIn hvFault;
    AnalogOut hvControl;
    unsigned stateChangeTime;
    double requestedOutputVoltage;
    
    rtos::RtosTimer updateTimer;
    rtos::Mutex mutex;
    
    ActivateState activateState;
    DeactivateSource deactivateSource;
};

#endif

