
#ifndef DEVICEPROPERTIES_H
#define DEVICEPROPERTIES_H

#include "Atomic.h"

enum OutputMode
{
    OMRamp = 0,
    OMConstantVoltage = 1,
    OMConstantPower = 2
};

struct DeviceConfig
{
    DeviceConfig(void);

    double activationStartVoltage;
    double constantPower;
    double constantVoltage;    
    double pwmFrequency;
    OutputMode outputMode;
    double rampEndPower;
    double rampStartPower;
    double rampMilliseconds;
    double totalActivationMilliseconds;
    int    samplePeriodMilliseconds;
    int    postActivationDelayMilliseconds;
    int    openLoopDurationMilliseconds;
    double kp;
    double ki;
    double kd;
    double iLim;
    double vLim;
    double vipCalibration;
    uint8_t msPIDPeriod;
};

enum DeactivateSource {
    DSNone,
    DSApplication,
    DSHVFault,
    DSSwitch
};

const int MAX_ACQUISITION_SAMPLES = 500;
struct AcquisitionData
{
    int timestampMilliseconds;
    float outputTarget; // can be voltage or power
    float outputVoltage;
    float iSense;
    float vSense;
    float iRMS;
    float vRMS;
    DeactivateSource deactivateSource;
};

class DeviceProperties
{
public:
    DeviceProperties(void);

    void AddAcquisitionSample(const AcquisitionData &data);
    void ClearAcquisitionData(void);

    int GetAcquisitionNumber(void);
    int GetAcquisitionSampleCount(void);
    AcquisitionData GetAcquisitionSample(int acquisition, int sample);
    DeviceConfig GetDeviceConfig(void) const { return deviceConfig.Get(); }
    double GetActualPWMFrequency(void) const;

    void SetActualPWMFrequency(double frequency);
    void SetDeviceConfig(const DeviceConfig &config) { deviceConfig.Set(config); }

private:
    Atomic<DeviceConfig> deviceConfig;
    AcquisitionData acquisitionData[MAX_ACQUISITION_SAMPLES];
    int acquisitionNumber;
    int acquisitionSampleCount;
    
    mutable rtos::Mutex mutex;
    double actualPwmFrequency;
};

extern DeviceProperties Device;

#endif

