
#include "Atomic.h"

#include "FullBridgeDriver.h"

#include "DeviceProperties.h"

DeviceProperties Device;

DeviceConfig::DeviceConfig(void)
{
    activationStartVoltage = 30;
    constantPower = 0;
    constantVoltage = 0;
    outputMode = OMRamp;
    pwmFrequency = DEFAULT_PWM_FREQUENCY;
    rampEndPower = 200;
    rampStartPower = 0;
    rampMilliseconds = 4000;
    samplePeriodMilliseconds = 100;
    postActivationDelayMilliseconds = 20;
    openLoopDurationMilliseconds = 100;
    totalActivationMilliseconds = 4000;
    kp = 0.1;
    ki = 0;
    kd = 0;
    msPIDPeriod = 3;
    iLim = 0;
    vLim = 0;
    vipCalibration = 1.0;
}




DeviceProperties::DeviceProperties(void)
{
    acquisitionSampleCount = 0;
    acquisitionNumber = 0;
}


void DeviceProperties::AddAcquisitionSample(const AcquisitionData &data)
{
    mutex.lock();
    if (acquisitionSampleCount < MAX_ACQUISITION_SAMPLES)
        acquisitionData[acquisitionSampleCount++] = data;
    mutex.unlock();
}


void DeviceProperties::ClearAcquisitionData(void)
{
    mutex.lock();
    ++acquisitionNumber;
    acquisitionSampleCount = 0;
    mutex.unlock();
}


int DeviceProperties::GetAcquisitionNumber(void)
{
    mutex.lock();
    int result = acquisitionNumber;
    mutex.unlock();
    return result;
}


int DeviceProperties::GetAcquisitionSampleCount(void)
{
    mutex.lock();
    int result = acquisitionSampleCount;
    mutex.unlock();
    return result;
}


AcquisitionData DeviceProperties::GetAcquisitionSample(int acquisition, int sample)
{
    mutex.lock();
    AcquisitionData result;
    if (acquisitionNumber==acquisition)
    {
        if (sample>=0 && sample<acquisitionSampleCount)
            result = acquisitionData[sample];
    }
    mutex.unlock();
    return result;
}


double DeviceProperties::GetActualPWMFrequency(void) const
{
    mutex.lock();
    double result = actualPwmFrequency;
    mutex.unlock();
    return result;
}


void DeviceProperties::SetActualPWMFrequency(double frequency)
{
    mutex.lock();
    this->actualPwmFrequency = frequency;
    mutex.unlock();
}



