
#ifndef CMSERIAL_H
#define CMSERIAL_H

#include "mbed.h"
#include "Thread.h"

#include "DeviceProperties.h"

class CMSerial
{
public:
    CMSerial(void);
    
private:
    double GetNumericArgument(int index, double defaultValue);
    void ThreadEntry(void);
    void ProcessCommand(void);
    bool CommandIs(const char *command);
    
private:
    DeviceConfig deviceConfig;
    DigitalOut led;
    Serial serial;
    char line[256];
    int lineLength;
    Thread thread;
};


#endif


