
#ifndef ATOMIC_H
#define ATOMIC_H

#include "Mutex.h"


template <class T> class Atomic {
public:
    Atomic(void) 
        :
            value()
    {
    }
    
    T Get(void) const {
        mutex.lock();
        T result = value;
        mutex.unlock();
        return result;
    }
    
    void Set(const T &value) {
        mutex.lock();
        this->value = value;
        mutex.unlock();
    }
    
private:
    mutable rtos::Mutex mutex;
    T value;    
};


#endif

