
#include "DeviceProperties.h"
#include "ADCInput.h"

ADCInput ADC;


ADCInput::ADCInput(void)
{
    iSense = NULL;
    vSense = NULL;
}


void ADCInput::Initialize(void)
{
    iSense = new AnalogIn(p16);
    vSense = new AnalogIn(p15);
    iRMS = new AnalogIn(p19);
    vRMS = new AnalogIn(p20);
}



double ADCInput::GetSensedCurrent(void)
{
    DeviceConfig config = Device.GetDeviceConfig();
    return iSense->read() * 3.3 * 1.0 * config.vipCalibration;
}


double ADCInput::GetSensedPower(void)
{
    return GetSensedVoltage() * GetSensedCurrent();
}


double ADCInput::GetSensedVoltage(void)
{
    DeviceConfig config = Device.GetDeviceConfig();
    return vSense->read() * 3.3 * 100 * config.vipCalibration;
}


double ADCInput::GetRMSVoltage(void)
{
    DeviceConfig config = Device.GetDeviceConfig();
    return vRMS->read() * 3.3 * 100 * config.vipCalibration;
}


double ADCInput::GetRMSCurrent(void)
{
    DeviceConfig config = Device.GetDeviceConfig();
    return iRMS->read() * 3.3 * 1.0 * config.vipCalibration;
}



