#ifndef wheelchair
#define wheelchair

#include "chair_imu.h"

#define def (2.5f/3.3f)
#define high 3.3f
#define offset .02f
#define low (1.7f/3.3f)
#define process .1
#define xDir D12 //top right two pins
#define yDir D13 //top left two pins

class Wheelchair
{
public:
    Wheelchair(PinName xPin, PinName yPin);
    void move(float x_coor, float y_coor);
    void turn_right();
    void turn_left();
    void forward();
    void backward();
    void right();
    void left();
    void stop();

private:
    PwmOut* x;
    PwmOut* y;
    chair_imu* imu;

};
#endif