#include "wheelchair.h"

// Note: 'def' is short for 'Default Position'

// Initialize Wheelchair Pins
Wheelchair::Wheelchair (PinName xPin, PinName yPin)
{
    x = new PwmOut(xPin);
    y = new PwmOut(yPin);
    imu = new chair_imu();
}

/*
*   Joystick has AnalogOut of 200-700, scale values between 1.3 and 3.3
*/

// Convert Joystick Values to Move the Wheelchair
void Wheelchair::move(float x_coor, float y_coor)
{
   
    float scaled_x = ((x_coor * 1.6f) + 1.7f) / 3.3f;
    float scaled_y = (3.3f - (y_coor * 1.6f)) / 3.3f;
    x->write(scaled_x);
    y->write(scaled_y); 
}

// Turn 90 degrees to the Right
void Wheelchair::turn_right(){
    double start = imu->yaw();
    double final = start + 90;
    if(final > 360)
        final -= 360;
   
    while(imu->yaw() <= final) {
        Wheelchair::right();
        } 
}

// Turn 90 degrees to the Left
void Wheelchair::turn_left(){
    double start = imu->yaw();
    double final = start - 90;
    if(final <0)
        final += 360;
   
    while(imu->yaw() >= final) {
        Wheelchair::left();
        } 
}

void Wheelchair::forward()
{
    x->write(high);
    y->write(def+offset);
}
 
void Wheelchair::backward()
{
    x->write(low);
    y->write(def);
}
 
void Wheelchair::right()
{
    x->write(def);
    y->write(high);
}
 
void Wheelchair::left()
{
    x->write(def);
    y->write(low);
}
 
void Wheelchair::stop()
{
    x->write(def);
    y->write(def);
}