#include "mbed.h"
#include "VL53L1X.h"

VL53L1X L(D14, D15);
Serial pc(USBTX, USBRX);

int main(){
    uint16_t d, sr;
    uint8_t rs;
    int r;
    // LED1 will blink if returns wrong Model ID
    // Blinking LED2 related to firmware 
    while (L.begin() == false){
        pc.printf("Sensor offline!\n");
        wait_ms(10);
    }
    
    pc.printf("Sensor online!\n");
    L.newDataReady();
    
    while(1){
        L.softReset();
        r = L.newDataReady();
        
        if(r){   
            L.setDistanceMode(2);
            d = L.getDistance();
            sr = L.getSignalRate();
            rs = L.getRangeStatus();
            pc.printf("newDataReady?: %d, Distance (mm): %d, SignalRate: %d, RangeStatus: %d\n", r, d, sr, rs);
        }
        
        wait_ms(500);
    }
    
}