#include "mbed.h"
#include <ros.h>
#include <geometry_msgs/Twist.h>

// Initialize ROS Node & Twist Message
ros::NodeHandle nh;
geometry_msgs::Twist commandRead;

ros::Publisher chatter("chatter", &commandRead);

// Initialize Subscribe Callback Functions
void handlerFunction(const geometry_msgs::Twist& command){
    commandRead = command;
}
ros::Subscriber<geometry_msgs::Twist> sub("cmd_vel", &handlerFunction);

int main() {
    // Initalize Node and Subscribe to Topic "cmd_vel"
    nh.initNode();
    nh.subscribe(sub);
    //nh.advertise(chatter);
    
    //commandRead.linear.x = 6.9;

    while (1) {
        // Jesus change line here
        // commandRead = actual velocity numbers
        // commandRead.linear.x = forward velocity
        // commandRead.angular.z = turning velocity
        chatter.publish(&commandRead);
        nh.spinOnce();
        wait_ms(10);
    }
}

