#include "mbed.h"
#include "PinDetect.h"
#include "rtos.h"

//stuff from mike 
#include "Phase_Finder.h"
#include "arm_math.h" 
//Filter coefficients. DO NOT DELETE. 
float b[51] = {-0.007772, -0.003741, -0.004376, -0.004861, -0.005128, -0.005108, -0.004726, -0.003925, -0.002650, -0.000867, 0.001443, 0.004277, 0.007607, 0.011379, 0.015521, 0.019940, 0.024525, 0.029149, 0.033671, 0.037953, 0.041851, 0.045248, 0.048020, 0.050070, 0.051335, 0.251747, 0.051335, 0.050070, 0.048020, 0.045248, 0.041851, 0.037953, 0.033671, 0.029149, 0.024525, 0.019940, 0.015521, 0.011379, 0.007607, 0.004277, 0.001443, -0.000867, -0.002650, -0.003925, -0.004726, -0.005108, -0.005128, -0.004861, -0.004376, -0.003741, -0.007772};


DigitalOut myled(LED1); //LEDS for debug purposes
DigitalOut myled2(LED2);
DigitalOut myled4(LED4);
AnalogIn audioIn(p20);//pin for sound capture
//AnalogOut outfunction(p18);
//DigitalOut masterSignalOut(p26);
InterruptIn startButton(p21);
InterruptIn printButton(p22);
InterruptIn sendToMasterButton(p23);
InterruptIn repeatRecording(p24);
//InterruptIn trigger(p25);
Serial pc(USBTX,USBRX);//serial to computer
Serial master(p13,p14);//serial to master
#define samples 301 //how many samples to take
float* signal; //set up the recording array
float* dataSlave1; //set up array for slave1's data
Timer ti; //Timer to determine sampling rate
int startTime;
int endTime;
int sampleRate;
int counter;
int start;
int print;
int send;
int verbose;

void startRecording(void){
    start = 1;
    myled2 = 1;
}
void startPrint(void){
    print = 1;
    myled4 = 1;
}
void startSend(void){
    send = 1;
}
int main() {
    
    
    
        //from mikes code
    float phases;
    float filteredSignal[351] = {}; //this array holds the signal after filtering. Make sure the input signal is > 300 samples. 
    Phase_Finder phase(50000, 900); //Create phase object
    
    
    
    ti.reset();
    start = 0;
    myled2 = 0;
    myled4 = 0;
    myled = 0;
    verbose = 0;
    //allocate memory to the data arrays
    signal = (float*) malloc(sizeof(float)*samples);
    dataSlave1 = (float*) malloc(sizeof(float)*samples);
    startButton.fall(&startRecording);
    printButton.fall(&startPrint);
    sendToMasterButton.fall(&startSend);
    repeatRecording.fall(&startRecording);
    //trigger.rise(&interruptrecv);
    //Thread threadanalog(analogScope);
    //threadanalog.set_priority(osPriorityLow);
    pc.printf("\nThis is Slave2\n");
    while(1) {
        if(start){ //once button is pressed
            //startTime = ti.read_us(); //get start time
            for(int i = 0;i<samples;i++){ //record 300 samples
                signal[i] = audioIn;
            }
            //endTime = ti.read_us(); //get end time
            //sampleRate = (int)(samples*1000000/(endTime-startTime)); //calculate sample rate
            
            
            arm_conv_f32(signal,    301 , b, 51, filteredSignal )   ; //Filtering operation
           float calcSignal[251] = {};
            for (int i = 0; i<251; i++){
               calcSignal[i] = filteredSignal[i+51];    
            }
            //Determine phase
            phases = phase.estimate(calcSignal, 251);
            
            
            start = 0; //stop
            send = 1; //set send to high to automatically start sending data
            
            
            
        }
        if(print){
               if(!verbose){
                   verbose = 1;
                   print = 0;
                }
                else{
                   pc.printf("\n");
                   for(int i = 0;i<samples;i++){
                        pc.printf("%5f ",signal[i]);
                    }
                    //pc.printf("\n %5d",sampleRate);
                    print = 0;
                }
                wait(0.3);
        }
        if(send){
            myled = 1;
            wait(0.5);
            char buffer[128];
            //for(int i =0;i<samples;i++){
                //pc.printf("%7f\n",phases);
                master.printf("%7f\n",phases);
                //master.printf("291.313\n",phases);
                //pc.printf("\nSamples:%7f,%7f,%7f",signal[0],signal[1],signal[300]);

            //}
            if(verbose){
                    pc.printf("\n***************\n");
                    for(int i = 0;i<samples;i++){
                        pc.printf("%5f ",signal[i]);
                    }
            }
            send = 0;
            myled = 0;
        }
    }
}
