#include "mbed.h"
#include "PinDetect.h"
#include "rtos.h"
#include "uLCD_4DGL.h"

//stuff from mike 
#include "AoA_Est.h"
#include "Phase_Finder.h"
#include "arm_math.h" 
//Filter coefficients. DO NOT DELETE. 
float b[51] = {-0.007772, -0.003741, -0.004376, -0.004861, -0.005128, -0.005108, -0.004726, -0.003925, -0.002650, -0.000867, 0.001443, 0.004277, 0.007607, 0.011379, 0.015521, 0.019940, 0.024525, 0.029149, 0.033671, 0.037953, 0.041851, 0.045248, 0.048020, 0.050070, 0.051335, 0.251747, 0.051335, 0.050070, 0.048020, 0.045248, 0.041851, 0.037953, 0.033671, 0.029149, 0.024525, 0.019940, 0.015521, 0.011379, 0.007607, 0.004277, 0.001443, -0.000867, -0.002650, -0.003925, -0.004726, -0.005108, -0.005128, -0.004861, -0.004376, -0.003741, -0.007772};

DigitalOut myled(LED1); //LEDS for debug purposes
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
AnalogIn audioIn(p20);//pin for sound capture
//AnalogOut outfunction(p18);
//DigitalOut masterSignalOut(p26);
InterruptIn startButton(p21);
InterruptIn printButton(p22);
InterruptIn sendToMasterButton(p23);
DigitalOut sendStartInterrupt(p24);
//InterruptIn trigger(p25);
Serial pc(USBTX,USBRX);//serial to computer
Serial slave1(p9,p10);//serial to slave 1
Serial slave2(p13,p14);//serial to slave 2
#define samples 301 //how many samples to take
float* signal; //set up the recording array
float* dataSlave1; //set up array for slave1's data
float* dataSlave2; //set up array for slave2's data
Timer ti; //Timer to determine sampling rate
float startTime;
float endTime;
float sampleRate;
int counter;
int start;
int print;
int receive;
int voting;
int verbose;

float angle[10];

uLCD_4DGL uLCD(p28,p27,p29);

void startRecording(void){
    start = 1;
    myled2 = 1;
}
void startPrint(void){
    print = 1;
    myled4 = 1;
}
void startReceive(void){
    receive = 1;   
}

void printDir(float angle)
{
    uLCD.cls();
    float x = 56 * cos(angle) + 64;
    float y = -56 * sin(angle) + 64;
    uLCD.line(64,64,x,y,0xFF0000);
    float x1 = 42 * cos(angle + 0.1745) + 64;
    float y1 = -42 * sin(angle + 0.1745) + 64;
    uLCD.line(x,y,x1,y1,0xFF0000);
    x1 = 42 * cos(angle - 0.1745) + 64;
    y1 = -42 * sin(angle - 0.1745) + 64;
    uLCD.line(x,y,x1,y1,0xFF0000);
    
    x1 = 56 * cos(angle + 0.3491) + 64;
    y1 = -56 * sin(angle + 0.3491) + 64;
    uLCD.line(64,64,x1,y1,0xFF8800);
    x1 = 56 * cos(angle - 0.3491) + 64;
    y1 = -56 * sin(angle - 0.3491) + 64;
    uLCD.line(64,64,x1,y1,0xFF8800);
    
    x1 = 42 * cos(angle + 0.5236) + 64;
    y1 = -42 * sin(angle + 0.5236) + 64;
    uLCD.line(64,64,x1,y1,0xFFFF00);
    x1 = 42 * cos(angle - 0.5236) + 64;
    y1 = -42 * sin(angle - 0.5236) + 64;
    uLCD.line(64,64,x1,y1,0xFFFF00);
}

int main() {
    
    //from mikes code
    int x[2] = { 150, 150 }; //x coordinates
    int y[2] = { 0, 90 }; //y
    float phases[10][3];
    float filteredSignal[351] = {}; //this array holds the signal after filtering. Make sure the input signal is > 300 samples. 
    Phase_Finder phase(50000, 900); //Create phase object
    
    ti.reset();
    counter = 0;
    start = 0;
    myled2 = 0;
    myled4 = 0;
    print = 0;
    receive = 0;
    voting = 0;
    verbose = 0;
    //allocate memory to the data arrays
    signal = (float*) malloc(sizeof(float)*samples);
    float dataMaster[10][301] = {};
    //dataSlave1 = (float*) malloc(sizeof(float)*samples);
    //dataSlave2 = (float*) malloc(sizeof(float)*samples);
    //masterSignalOut = 0;
    //startButton.mode(PullUp);
    startButton.fall(&startRecording);
    //printButton.mode(PullUp);
    printButton.fall(&startPrint);
    sendToMasterButton.fall(&startReceive);
    //trigger.rise(&interruptrecv);
    //Thread threadanalog(analogScope);
    //threadanalog.set_priority(osPriorityLow);
    sendStartInterrupt = 0;
    pc.printf("\nThis is Master\n");
    while(1) {
        //myled2 = !myled2;
        if(start){ //once button is pressed
            
            // run 5 times for majority voting
            //for (int trial = 0; trial < 10; trial++){
                // first recording starts with button press
                // second through tenth recording starts after sending interrutps to slave mbeds
                
                
                // recording and calculating phase ******************************************************************
                //startTime = ti.read_us(); //get start time
                //    ti.start();
                for(int i = 0;i<samples;i++){ //record 301 samples
                    signal[i] = audioIn;
                    //dataMaster[counter][i] = audioIn;
                }
                start = 0; //stop
                
                arm_conv_f32(signal,    301 , b, 51, filteredSignal )   ; //Filtering operation
                float calcSignal[251] = {};
                for (int i = 0; i<251; i++){
                    calcSignal[i] = filteredSignal[i+51];    
                }
                //Determine phase
                phases[counter][0] = phase.estimate(calcSignal, 251);
                sendStartInterrupt = 0;
                myled3 = 0;
                
                // receiving phases from slave mbeds and calculating angle ******************************************
                
                char buffer[128];
                
                //get phase from slave 1
                wait(.1);
                myled = 1;
                slave1.gets(buffer,15);
                //pc.printf(buffer);
                phases[counter][1] = atof(buffer);
                
                myled = 0;
                
                //get phase from slave 2
                wait(.3);
                myled = 1;
                slave2.gets(buffer,15);
                //pc.printf(buffer);
                phases[counter][2] = atof(buffer);
                //uLCD.locate(0,1);
                //uLCD.printf("%f\n%f\n%f\n",phases[0],phases[1],phases[2]);
                
                //AoA object
                AoA_Est AoA(3, x, y, 900); 
                angle[counter] = AoA.estimate(phases[counter], phases[counter]); //It accepts a magnitude vector as the second argument. Not currently used so just put the phases there.
                if (isnan(angle[counter])) counter--;
                receive = 0;
                myled = 0;
                counter++;
                uLCD.locate(15,0);
                uLCD.printf("%d\n",counter);
                
                // sending out interrupt signals to slave mbed to repeat recording trials ******************************************
                // currently set as rising edge trigger, can be changed
                myled3 = 1;
                start = 0;
                if(counter==10) voting = 1;
                //pc.printf("\nSamples:%7f,%7f,%7f",signal[0],signal[1],signal[300]);
                if(verbose){
                  pc.printf("\nTrial #:%d\n",counter);
                  pc.printf("Master's samples:\n");
                  for(int i = 0;i<samples;i++){
                    pc.printf("%5f ",signal[i]);   
                  }
                  pc.printf("\nPhases: Master, Slave1, Slave 2\n");
                  pc.printf("%f, %f, %f\n",phases[counter][0],phases[counter][1],phases[counter][2]);
                  pc.printf("Angle calculated by Master\n");
                  pc.printf("%5f",angle[counter]);
                }
                wait(0.5);
                if (counter < 10) {
                    start = 1;
                    sendStartInterrupt = 1;
                 }   
                
            //}
            
            
        }
        
        if(print){
               if(!verbose){
                   verbose = 1;
                   print = 0;
                   uLCD.locate(0,12);
                   uLCD.printf("Verbose mode");
                }
               else{
               pc.printf("\n");
               for(int i = 0;i<samples;i++){
                    pc.printf("%5f ",signal[i]);
                }
                //pc.printf("\n %5f",sampleRate);
                //pc.printf("\n***********************************\n");
                //for(int i = 0;i<samples;i++){
                    //pc.printf("%5f ",dataSlave1[i]);
                //}
                //pc.printf("\n***********************************\n");
                //for(int i = 0;i<samples;i++){
                    //pc.printf("%5f ",dataSlave2[i]);
                //}
                print = 0;
                }
                wait(0.3);
        }
        if(receive){
            //counter = 0;
            char buffer[128];
            
            //get phase from slave 1
            myled = 1;
            slave1.gets(buffer,15);
            pc.printf(buffer);
            phases[counter][1] = atof(buffer);
            
            
            myled = 0;
            
            //get phase from slave 2
            wait(.15);
            myled = 1;
            slave2.gets(buffer,15);
            pc.printf(buffer);
            phases[counter][2] = atof(buffer);
            
            uLCD.locate(0,1);
            uLCD.printf("%f\n%f\n%f\n",phases[counter][0],phases[counter][1],phases[counter][2]);
            
            //AoA object
            AoA_Est AoA(3, x, y, 900); 
            float angle = 0;
            angle = AoA.estimate(phases[counter], phases[counter]); //It accepts a magnitude vector as the second argument. Not currently used so just put the phases there.
            receive = 0;
            myled = 0;
            uLCD.locate(0,0);
            uLCD.printf("%f\n",angle);
        }
        if(voting){
        // majority voting
            // find mean and standard deviation
            // if standard deviation is too high, drop the outlier, then try again until it is small
            // mean without the outlier is the final result
            
            // find whether degrees 0 to 360 or -180 to 180 is better
            float mean = 0.0;
            float mean1 = 0.0;
            float var = 0.0;
            float var1 = 0.0;
            float tries = 10.0;
            for (int i = 0; i < 10; i++){
                mean = mean + angle[i];
                mean1 = mean1 + angle[i];
                if (angle[i] > 180) mean1 = mean1 - 360.0;
                var = var + (angle[i] * angle[i]);
                if (angle[i] > 180) var1 = var1 + (angle[i] * angle[i]);
                else var1 = var1 + ((angle[i] - 360.0) * (angle[i] - 360.0));
            }
            mean = mean / tries;
            mean1 = mean1 / tries;
            var = (var / tries) - (mean * mean);
            var1 = (var1 / tries) - (mean1 * mean1);
            if (var > var1){
                mean = mean1;
                for (int i = 0; i < 10; i++){
                    if (angle[i] > 180) angle[i] = angle[i] - 360.0;
                }
            }
            
//            int voting = 1;
//            int outlier[5] = {0, 0, 0, 0, 0};
//            while (voting){
//                // calcualting mean and variance (square of std dev)
//                float votes = 0.0;
//                mean = 0.0;
//                var = 0.0;
//                for (int i = 0; i < 5; i++){
//                    if (outlier[i] == 0){
//                        mean = mean + angle[i];
//                        var = var + (angle[i] * angle[i]);
//                        votes = votes + 1.0;
//                    }
//                }
//                mean = mean / votes;
//                var = (var / votes) - (mean * mean);
//                
//                // if std dev is greater than 10, find outlier
//                // else, done voting
//                if (var > 100){
//                    for (int i = 0; i < 5; i++){
//                        if ((outlier[i] == 0) && (abs(mean - angle[i]) > 10)) outlier[i] = 1;
//                    }
//                }
//                else voting = 0;
//            }
            printDir(mean * 3.1416 / 180.0);
            uLCD.locate(0,0);
            uLCD.printf("%3.0f", mean);
            uLCD.locate(0,10);
            uLCD.printf("%3.0f\n", angle[0]);
            uLCD.printf("%3.0f\n", angle[1]);
            uLCD.printf("%3.0f\n", angle[2]);
            uLCD.printf("%3.0f\n", angle[3]);
            uLCD.printf("%3.0f\n", angle[4]);
            for(int i = 0;i<10;i++){
            pc.printf("\n%3.0f",angle[i]);
            }
            for(int i = 0;i<10;i++){
                pc.printf("\n%3.0f,%3.0f,%3.0f",phases[i][0],phases[i][1],phases[i][2]);
            voting = 0;
            counter = 0;
            }
        }
        
    }
}
