#include "mbed.h"
#include "string.h"
using namespace std;
 
Serial PC(PA_9, PA_10);
Serial SYN(PC_10, PC_11);

void voice_play(char* value, Serial* ser) {
    int size = strlen(value);
    int data_length = 1+2+1+1+size;
    int* data = (int*)malloc(sizeof(int)*(data_length+1));
    
    int start = 0xfd;
    int length = size + 3;
    int length_h = length / 256;
    int length_l = length % 256;
    int command = 0x01;
    int param = 0x01;
    
    data[0] = start;
    data[1] = length_h;
    data[2] = length_l;
    data[3] = command;
    data[4] = param;

    for (int i=5; i<5+size; i++) {
        data[i] = value[i-5];
    }

    // calculate check bit
    int check_bit = data[0];
    for (int i=1; i<data_length; i++) {
        check_bit ^= data[i];
    }   
    data[data_length] = check_bit;

    for (int i=0; i<=data_length; i++) {
        ser->putc(data[i]);
    }
    
    free(data);
    
    //int recv = ser->getc();
    //PC.printf("%c", recv);
    //int done = ser->getc();
    //PC.printf("%c", done);   
}

int main() {
    PC.printf("start\n");
    char hello[] = {0xc4,0xfa,0xba,0xc3,0xbb,0xb6,0xd3,0xad,0xbb,0xd8,0xbc,0xd2, 0x00};
    voice_play(hello, &SYN);
    // SYN.printf("debug\n");
    // PC.printf("start\n");
    while(1) {       
        char name[200];
        int width = -1;
        int height = -1;
        if (PC.readable()) {
            PC.scanf("%[^,],%d,%d", name, &width, &height);
            char hello[] = {0xc4,0xfa,0xba,0xc3,0xbb,0xb6,0xd3,0xad,0xbb,0xd8,0xbc,0xd2, 0x00};
            strcat(name, hello);
            voice_play(name, &SYN);
        }
    }
}