#include "mbed.h"
#include "DebounceIn.h"
#include <cstring>
#include <string>
#include "uLCD_4DGL.h"

#define SEQ_LEN             20

DigitalOut LED_RED(p17);
DigitalOut LED_GREEN(p18);
DigitalOut LED_BLUE(p19);
AnalogIn   randSeed(p20);
uLCD_4DGL   myLCD(p9,p10,p11);

DigitalOut myled(LED1);

char letters[26] = {'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y','Z'};
int scores[3] = {7, 5, 3};
string names[3] = {"Comp1", "Comp2", "Comp3"};


int invert(int value);
void inputName(int);
void pb1_hit_callback(void);
void pb2_hit_callback(void);
void pb3_hit_callback(void);
void pb4_hit_callback(void);
void createSequence(int *Sequence, int length);
void startScreen();
void displayHighScores();

DebounceIn pb1(p21);
DebounceIn pb2(p22);
DebounceIn pb3(p23);
//DebounceIn pb4(p24);

// array for pattern
int Sequence[SEQ_LEN];

int main()
{
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    //pb4.mode(PullUp);
    while(1) {
        //loop
        myLCD.cls();
        startScreen();
        int val1, val2, val3,Num;
        int length = 1;
        int Tally = 0;
        int j = 0;
        while(1) {
            //declares the arrays used for the game
            int Sequence[length];
            int Score[length];
            int Imput[length];
            createSequence(Sequence, length);
            wait(1);
            //creats a random sequence of size length
            for(int i=0; i<length; i++) {
                Num = Sequence[i];
                if(Num == 0) {
                    LED_RED = 1;
                    Score[i] = 0;
                    wait(0.4);
                    LED_RED = 0;
                    wait(0.4);
                }
                if(Num == 1) {
                    LED_GREEN = 1;
                    Score[i] = 1;
                    wait(0.4);
                    LED_GREEN = 0;
                    wait(0.4);
                }
                if(Num == 2) {
                    LED_BLUE = 1;
                    Score[i] = 2;
                    wait(0.4);
                    LED_BLUE = 0;
                    wait(0.4);
                }
            }
            // allows the user to imput the random pattern
            while(1) {
                // pushbuttons pull low when pressed, so invert them
                val1 = invert(pb1.read());
                val2 = invert(pb2.read());
                val3 = invert(pb3.read());
                //val4 = invert(pb4.read());

                if(val1) {
                    pb1_hit_callback();
                    Imput[j] = 0;
                    j=j+1;
                }
                if(val2) {
                    pb2_hit_callback();
                    Imput[j] = 1;
                    j=j+1;
                }
                if(val3) {
                    pb3_hit_callback();
                    Imput[j] = 2;
                    j=j+1;
                }
                if(j == length) {
                    j = 0;
                    break;
                }
            }

            // if wrong end the game
            for(int i=0; i<length; i++) {
                if(Score[i] != Imput[i]) {
                    inputName(Tally);
                    length = 1;
                    Tally = 0;
                    displayHighScores();
                    wait(4);
                    startScreen();
                    break;
                }
                //if correct add to score and add one to sequence size
                if(i == length - 1) {
                    Tally = Tally + 1;
                    length++;
                    break;
                }
            } // end of For
        } // End of While
    }//End of First While
}//End of Main

//function to perform bitwise inversion
int invert(int value)
{
    if (value == 0) {
        return 1;
    } else {
        return 0;
    }
}

//create a sequence and store in Sequence[]
void createSequence(int *Sequence, int length)
{
    srand((int ) (randSeed * 50000)); // seed the pseudo-random number generator with electrical noise from a pin
    for(int i=0; i<length; i++) {
        Sequence[i] = rand() % 3;
    }
}

//functions to call when a pushbutton is pressed
void pb1_hit_callback (void)
{
    LED_RED = 1;
    wait(0.2);
    LED_RED = 0;
    wait(0.2);
}
void pb2_hit_callback (void)
{
    LED_GREEN = 1;
    wait(0.2);
    LED_GREEN = 0;
    wait(0.2);
}
void pb3_hit_callback (void)
{
    LED_BLUE = 1;
    wait(0.2);
    LED_BLUE = 0;
    wait(0.2);
}

void startScreen()
{
    myLCD.cls();
    myLCD.text_width(2);
    myLCD.text_height(2);
    myLCD.text_string("PRESS OK", 1, 2, FONT_7X8, GREEN);
    myLCD.text_string("TO START", 1, 3, FONT_7X8, GREEN);
    int Start;
    int a = 0;
    while(1) {
        Start = invert(pb1.read());
        if(Start) {
            displayHighScores();
            a++;
        }
        if(a == 1) {
            a = 0;
            wait(.5);
            break;
        }
    }
    return;
}

void displayHighScores()
{
    int max = 0;
    int min = 0;
    for (int i = 0; i < 3; ++i) {
        if (scores[min] > scores[i]) min = i;
        if (scores[max] < scores[i]) max = i;
    }
    int mid;

    int sum = max + min;
    if (max == min) {
        mid = 1;
        max = 2;
    } else if (sum == 1) {
        mid = 2;
    } else if (sum == 2) {
        mid = 1;
    } else if (sum == 3) {
        mid = 0;
    }
    myLCD.cls();
    myLCD.printf("HIGH SCORES\n");
    string s1 = string(names[max]);
    myLCD.printf("1. %s - %d\n", string(names[max]), scores[max]);
    myLCD.printf("2. %s - %d\n", string(names[mid]), scores[mid]);
    myLCD.printf("3. %s - %d\n", string(names[min]), scores[min]);

    //myLCD.text_string("HIGH SCORES", 1, 1, FONT_7X8, RED);
    //myLCD.text_string("HALLO", 1, 2, FONT_7X8, RED);

    /*myLCD.text_string(("1. %s - %d", names[max], scores[max]), 1, 2, FONT_7X8, WHITE);
    myLCD.text_string(("2. %s - %d", names[mid], scores[mid]), 1, 3, FONT_7X8, WHITE);
    myLCD.text_string(("3. %s - %d", names[min], scores[min]), 1, 4, FONT_7X8, WHITE);*/

    return;

}

void inputName(int score)
{

    
    bool bigger = false;
    for (int i = 0; i < 3; ++i) {
        if (scores[i] < score) {
            bigger = true;
        }
    }
    
    if (bigger != true) {
        return;
    }

    int letterPointer = 0;
    int namePointer = 0;
    int okay;
    int forward;
    int backward;
    char name[3] = {'A', 'A', 'A'};
    myLCD.cls();
    myLCD.printf("Score: \t %d", score);
    myLCD.text_width(4);
    myLCD.text_height(4);

    while(1) {

        char c = letters[letterPointer];
        myLCD.text_string(&c, 2, 2, FONT_7X8, RED);
        //myLCD.text_string(name, 1, 1, FONT_7X8, RED);

        okay = invert(pb1.read());
        forward = invert(pb2.read());
        backward = invert(pb3.read());
        if (backward) {
            if (letterPointer == 0) {
                wait(0.2);
                letterPointer = 25;

            } else {
                wait(0.2);
                --letterPointer;
            }
        }
        if (forward) {
            if (letterPointer == 25) {
                wait(0.2);
                letterPointer = 0;
            } else {
                wait(0.2);
                ++letterPointer;
            }
        }
        if (okay) {
            wait(0.2);
            name[namePointer] = letters[letterPointer];
            myLCD.text_string(&c, 2, 2, FONT_7X8, BLUE);

            if (namePointer < 2) {
                ++namePointer;
            } else {
                int mini = 0;
                for (int i = 0; i < 3; ++i) {
                    if (scores[mini] > scores[i]) mini = i;
                }
                names[mini] = name;
                scores[mini] = score;
                myLCD.text_string(name, 1, 2, FONT_7X8, GREEN);
                return;
            }

        }
    }
}