#include "mbed.h"
#include "Motor.h"

Serial pc(USBTX,USBRX);     // Declare serial connection
Motor my_motor(PTB1,PTB0);  // Declare motor and motor pin addresses

int main() {
    
    pc.baud(9600);
    int slidervalue = 64;
    int readvalue = 0;
    
    
    while (1) {
        

        readvalue = int(pc.getc());     // reads the value from the serial port and stores it as "readvalue"
        
        if (readvalue >=1 && readvalue <=127) {    // checks to make sure "readvalue" is within a valid range
            slidervalue = readvalue;
        }
        
        my_motor.Spin((float(slidervalue) - 1.0)/126.0);    // turns "slidervalue" into a percentage and sends it to the motor's Spin function

    }
}