#include "mbed.h"
#include "Motor.h"

Motor::Motor(PinName Positive, PinName Negative): _positive(Positive), _negative(Negative){
     _positive.period(0.03f);      // .03 second period
     _positive.write(0.25f);       // initial duty cycle
     _negative.period(0.03f);      // .03 second period
    _negative.write(0.25f);        // initial duty cycle
     
}   


void Motor::Spin(float move) {
    
    if(move >= .51){                //direction and speed when percentage is above .51
     _positive = (move-.5);
     _negative = 0;
     }
     
    else if(move <= .49){           //direction and speed when percentae is below .49
     _positive = 0;
     _negative = (.5-move);
     }
     
    else if(move > .49 && move < .51){      //stop motor when precentage is about .50
     _positive = 0;
     _negative = 0;
     }
     
}