#include "radio.h"
#include "MbedJSONValue/MbedJSONValue.h"

// Semtech radio definitions for SX127x, SX126x and SX128x

#if defined(SX127x_H)
    #define BW_KHZ              500
    #define SPREADING_FACTOR    11
    #define CF_HZ               912000000
#elif defined(SX126x_H)
    #define BW_KHZ              500
    #define SPREADING_FACTOR    10
    #define CF_HZ               913000000
#elif defined(SX128x_H)
    #define BW_KHZ              200
    #define SPREADING_FACTOR    7
    #define CF_HZ               2487000000
#endif

DigitalOut myled(LED1);

/**********************************************************************/

void txDoneCB()
{
}

void rxDoneCB(uint8_t size, float rssi, float snr)
{
    MbedJSONValue message;
    printf("%.1fdBm  snr:%.1fdB\t", rssi, snr);

    myled.write(!myled.read()); // toggle LED

    //Determine if the packet is JSON formatted by checking first character
    if(Radio::radio.rx_buf[0] == '{')
    {
        printf("JSON Format!\r\n");
        // Display payload packet information
        char* json = (char*)Radio::radio.rx_buf;
        printf("Message: %s\r\n", json);       
        parse(message, (char*)json);
        printf("\r\n\n");
        if(message.hasMember("btn_count"))
        {
            printf("btn_count: %d\r\n", message["btn_count"].get<int>());
        }
        if(message.hasMember("btn_timer"))
        {
            printf("btn_timer: %f\r\n", message["btn_timer"].get<double>());
        }
        if(message.hasMember("light_val"))
        {
            printf("light_val: %f\r\n", message["light_val"].get<double>());
        }
        if(message.hasMember("light_resistance"))
        {
            printf("light_resistance: %f\r\n", message["light_resistance"].get<double>());
        }
        if(message.hasMember("temperature"))
        {
            printf("temperature: %f\r\n", message["temperature"].get<double>());
        }
        if(message.hasMember("my_str"))
        {
            printf("my_str: %s\r\n", message["my_str"].get<string>().c_str());
        }
        if(message.hasMember("my_boolean"))
        {
            printf("my_bool: %s\r\n", message["my_boolean"].get<bool>() ? "true" : "false");
        }       
        printf("\r\n\n");
    }
    else
    {
        printf("Byte Format!\r\n");
        // Display payload packet information
        for (int i = 0; i < size; i++) {
            printf("%02d ", Radio::radio.rx_buf[i]);   // Changed to "%02d \n"
        }
        printf("\r\n\n");
    }
    
}

const RadioEvents_t rev = {
    /* Dio0_top_half */     NULL,
    /* TxDone_topHalf */    NULL,
    /* TxDone_botHalf */    txDoneCB,
    /* TxTimeout  */        NULL,
    /* RxDone  */           rxDoneCB,
    /* RxTimeout  */        NULL,
    /* RxError  */          NULL,
    /* FhssChangeChannel  */NULL,
    /* CadDone  */          NULL
};

int main()
{   

    // POR & Reset debug message    
    printf("\r\nreset-rx\r\n");
    
    Radio::Init(&rev);

    // Radio Start
    
    Radio::Standby();
    Radio::LoRaModemConfig(BW_KHZ, SPREADING_FACTOR, 1);
    Radio::SetChannel(CF_HZ);

    // preambleLen, fixLen, crcOn, invIQ
               
    Radio::LoRaPacketConfig(8, false, true, false);
    
    // Start radio receiver, wait for packets from transmitter

    Radio::Rx(0);
    
    for (;;) {     
        Radio::service();
    }
}
