
  #include "mbed.h"
  #include "Keypad.h"
#include "TextLCD.h"

//pin selection for keypad matrix

 Keypad kpad(PTE2,PTE3,PTE4,PTE5,PTB8,PTB9,PTB10,PTB11); 
 
// all digital inputs

 /*
Keypad kpad(col1, col2, col3, col4, row1, row2, row3, row4)
*/

// serial connection to pc for debugging and troubleshooting
 Serial pc(USBTX, USBRX);
 
//define passwords of for individual users
const uint32_t number_of_chars = 5; //password length
const char pass_user1[number_of_chars] = {'1','2','3','4','*'}; //password user 1
const char pass_user2[number_of_chars] = {'1','4','7','4','*'}; // password user 2
const char pass_user3[number_of_chars] = {'0','0','0','0','0'}; // password user 3
const char pass_user4[number_of_chars] = {'6','5','4','C','*'}; // password user 4
const char pass_user5[number_of_chars] = {'A','A','A','A','A'}; // password user 5

//choose the character length of valid passwords
char enterd_pass[number_of_chars] = {' ',' ',' ',' ',' '}; 

// each (‘ ‘) represents a location for inputs from keypad


//initialize outputs
DigitalOut led_red(LED_RED);       //red led turned on                                    
DigitalOut led_green(LED_GREEN);   //green led turned on     
DigitalOut output2(PTA4);          // normally off digital output   
DigitalOut output1(PTA5);          // normally on  digital output
  
  
PwmOut beep(PTD4); // buzzer

int main()
{
    char key;
    int i;
   int user_index1=0;
    int user_index2=0;
    int user_index3=0;
    int user_index4=0;
    int user_index5=0;
    int j=0;        // incorrect entry counter
    int flag=0;         //lockout flag
    
printf("\n \n PASSWORD REQUIRED \n \n ");

    int released =1;    // variable to detect if a key is being  pressed on keypad
  
    output1=0;      // digital output
    printf("\r\n Password Entered:");
    led_green = 0;  //LED green on
    led_red = 0;        //LED red on
//red and green led turned on to create yellow

    output2 = 1;  // buzzer alarm off

//buzzer period select,                 
    beep.period(0.001); // determines pitch and sound frequency
    
    wait(0.001);    //off time

















////beginning of do-while loop to activate system lockout after too many login attemps   
do{

    while(1) {

        led_green = 0;
        led_red = 0;
        printf("Enter Password:");
        
        // Reading the password characters
        for(i=0; i<number_of_chars; i++) {

            key = kpad.ReadKey();       // for loop reads each character entered up to 
                                        // number of chars in a password


    if(key == '\0')                          // if no character is being typed
             released = 1;                   //set the flag when all keys are released

      if((key != '\0') && (released == 1))   //if key pressed AND previous key released
       { 

       enterd_pass[i]=key;      
       printf("%c ",enterd_pass[i]);           
       released = 0;              //flag to indicate that key is pressed
              }
else
i--;
          

           
        }
        
        wait(0.003);

        //// prompts entered passcode and is compared to preset user passcodes 
        //// comparing password entered via keypad to valid user passwords

      /////////    user 1    ///////////////
        for(i=0; i<number_of_chars; i++) {
            if( enterd_pass[i] == pass_user1[i] ) {
                user_index1 = 1;
               output2 = 1;
            } else {
                user_index1 = 0;
                break;
            }
        }
        
        

        /////////    user 2    ///////////////
        for(i=0; i<number_of_chars; i++) {
            if( enterd_pass[i] == pass_user2[i] ) {
                user_index2 = 2;
            } else {
                user_index2 = 0;
                break;
            }
        }
        /////////    user 3    ///////////////
        for(i=0; i<number_of_chars; i++) {
            if( enterd_pass[i] == pass_user3[i] ) {
                user_index3 = 3;
            } else {
                user_index3 = 0;
                break;
            }
        }
        /////////    user 4    ///////////////
        for(i=0; i<number_of_chars; i++) {
            if( enterd_pass[i] == pass_user4[i] ) {
                user_index4 = 4;
            } else {
                user_index4 = 0;
                break;
            }
        }
        /////////    user 5    ///////////////
        for(i=0; i<number_of_chars; i++) {
            if( enterd_pass[i] == pass_user5[i] ) {
                user_index5 = 5;
            } else {
                user_index5 = 0;
                break;
            }
        }
        
        // if passcode matches a user passcode
        // continue to grant user accress and activate outputs
       
    ////// correct password prompts and outputs  //////

        if( (1 == user_index1)||(2 == user_index2)||(3 == user_index3)||(4 == user_index4)||(5 == user_index5) )  

// if user index is between 1 and 5 and not 0
{
            printf("\r\n Passcode recognized \n \n ");          // correct passcode prompt
            led_red = 1;                           // red led has 0V, leaving green led on
            output2 = 0;                     // activates short buzzer
            output1=1;                              // activates short buzzer 
            printf("\r\n Welcome Cory Burke \n \n" );
           
          output1=1;                               // output 1 activated

            if(1 == user_index1) {
                printf("\r Access granted User 1 \n \n");              // User 1’s name can be entered her      
            led_red = 1;                        //red led turned off
            output2 = 1;                  // activates short buzzer 
            printf("\r\n Welcome User 1 \n" );
            printf("\r User numer: 1 \n");
            output1=0;
            }
            if(2 == user_index2) {
                printf("\r\n Access granted: User 2 \n \n ");
            led_red = 1;                        //red led turned off
            output2 = 1;                  // activates short buzzer 
            printf("\r\n Welcome User 2 \n" );
            printf("\r User numer: 2 \n");
            output1=0;                      // output1 turned off
            }
            if(3 == user_index3) {
                printf("\r\n Access granted: User 3  \n ");
            led_red = 1;                        //red led turned off
            output2 = 1;                  // activates short buzzer 
            printf("\r\n Welcome User 3 \n" );
            printf("\r User numer: 3 \n ");
            output1=0;                      // output1 turned off
            }
            if(4 == user_index4) {
                printf("\r\n Access granted: User 4   \n ");
            led_red = 1;                        //red led turned off
            output2 = 1;                  // activates short buzzer 
            printf("\r\n Welcome User 4 \n" );
            printf("\r User numer: 4 \n");
            output1=0;                      // output1 turned off
            }
            if(5 == user_index5) {
                printf("\r Access granted: User 5 \n ");
            led_red = 1;                        //red led turned off
            output2 = 1;                  // activates short buzzer 
            printf("\r\n Welcome User 5 \n " );
            printf("\r User numer: 5 \n");
            output1=0;                      // output1 turned off
            }

            wait(1);
            output2 = 0;
            beep = 25.0/100.0;          // beep duty cycle to control volume and pitch
            led_red = 0;                //  
            led_green=0;                //red and green led turned on to create yellow
            output1=1;              // output1 turned off
            wait(1);
      


        }
///// when an incorrect password was entered 
        else {
            printf("\r\n \n Incorrect password \n \n Access denied!  \n \n  ");
            led_green = 1;              //green led turned off
            led_red=0;              //red led turned on
            wait(1);
            output2 = 0;          // buzzer off
             beep = 50.0/100.0;
            j=j+1;                  //  records access attempt
            //// too many attempts made

            if(j==4){printf("\r\n \n TOO MANT ATTEMPTS, SYSTEM LOCKOUT  \n \n  ");
            led_green = 1;      //green led turned off
            led_red=0;      //red led turned on
            flag=1;         //lockout flag activated
            wait(1);
            output2 = 1;       // long buzzer when system lockout occurs
             beep = 50.0/100.0; 
               output1=0;       // output1 turned on
            wait(1);
             output1=0;
            wait(1);
             output1=1;
            wait(1);
             output1=0;
            wait(1);
             output1=1;
            wait(1);    //long buzzer ends
                                                                            }
            
                                                                    }
        
        beep = 0.0/100.0;   // buzzer turned off by duty cycle = 0
        led_green = 0;      //green led turned on
            led_red=0;      //red led turned on
                            //red and green led turned on to create yellow
        output2 = 0;                  
        output1=1; 

    }
    
    
    
    
    
 } while(flag==0); ////end of do-while loop, continues until flag =1 from too many attempts 
                
    
    
    ////end of program
    
    
}





























