  #include "mbed.h"
  #include "Keypad.h"
#include "TextLCD.h"

//pin selection for keypad matrix

 Keypad kpad(PTE2,PTE3,PTE4,PTE5,PTB8,PTB9,PTB10,PTB11);
 
 /*
col1, col2, col3, col4, row1, row2, row3, row4
*/

// serial connection to pc for debugging and troubleshooting
 Serial pc(USBTX, USBRX);
 
//define passwords of for individual users
const uint32_t number_of_chars = 5; //password length
const char pass_user1[number_of_chars] = {'1','2','3','4','*'}; //
const char pass_user2[number_of_chars] = {'1','4','7','4','*'}; //
const char pass_user3[number_of_chars] = {'0','0','0','0','0'}; //
const char pass_user4[number_of_chars] = {'6','5','4','C','*'}; //
const char pass_user5[number_of_chars] = {'A','A','A','A','A'}; //

//choose the character length of valid passwords
char enterd_pass[number_of_chars] = {' ',' ',' ',' ',' '};


//initialize outputs
DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
DigitalOut active_buzzer(PTA4);
DigitalOut output1(PTA5);
  //Buzzer on pin PTD4

PwmOut beep(PTD4); // buzzer

int main()
{
    char key;
    int i;
   int user_index1=0;
    int user_index2=0;
    int user_index3=0;
    int user_index4=0;
    int user_index5=0;
    int j=0;
    int flag=0;
    
printf("\n \n PASSWORD REQUIRED \n \n ");

    int released =1;
  
    output1=1;
    printf("\r\n Password Entered:");
    led_green = 0;
    led_red = 0;
    active_buzzer = 0;

//buzzer period select
    beep.period(0.001);
    
    wait(0.001);

    
do{
    while(1) {
        led_green = 0;
        led_red = 0;
        printf("Enter Password:");
        
        // Reading the password characters
        for(i=0; i<number_of_chars; i++) {
            key = kpad.ReadKey();
        
    if(key == '\0')
             released = 1;                       //set the flag when all keys are released
           if((key != '\0') && (released == 1)) {  //if a key is pressed AND previous key was released
        enterd_pass[i]=key; 
        printf("%c ",enterd_pass[i]);           
              released = 0;                       //clear the flag to indicate that key is still pressed
              }
else
i--;
          

           
        }
        
        wait(0.003);
        
        // comparing password entered via keypad to valid user passwords

      /////////    user 1    ///////////////
        for(i=0; i<number_of_chars; i++) {
            if( enterd_pass[i] == pass_user1[i] ) {
                user_index1 = 1;
                active_buzzer = 0;
            } else {
                user_index1 = 0;
                break;
            }
        }
        
        

        /////////    user 2    ///////////////
        for(i=0; i<number_of_chars; i++) {
            if( enterd_pass[i] == pass_user2[i] ) {
                user_index2 = 2;
            } else {
                user_index2 = 0;
                break;
            }
        }
        /////////    user 3    ///////////////
        for(i=0; i<number_of_chars; i++) {
            if( enterd_pass[i] == pass_user3[i] ) {
                user_index3 = 3;
            } else {
                user_index3 = 0;
                break;
            }
        }
        /////////    user 4    ///////////////
        for(i=0; i<number_of_chars; i++) {
            if( enterd_pass[i] == pass_user4[i] ) {
                user_index4 = 4;
            } else {
                user_index4 = 0;
                break;
            }
        }
        /////////    user 5    ///////////////
        for(i=0; i<number_of_chars; i++) {
            if( enterd_pass[i] == pass_user5[i] ) {
                user_index5 = 5;
            } else {
                user_index5 = 0;
                break;
            }
        }
        
       
////// correct password prompts and outputs
        if( (1 == user_index1)||(2 == user_index2)||(3 == user_index3)||(4 == user_index4)||(5 == user_index5) ) {
            printf("\r\n Passcode recognized \n \n ");
            led_red = 1;
            active_buzzer = 0;
            printf("\r\n Welcome Cory Burke \n \n" );
           
          output1=0;

            if(1 == user_index1) {
                printf("\r Access granted User 1 \n \n");
            led_red = 1;
            active_buzzer = 0;
            printf("\r\n Welcome User 1 \n" );
            printf("\r User numer: 1 \n");
            output1=0;
            }
            if(2 == user_index2) {
                printf("\r\n Access granted: User 2 \n \n ");
            led_red = 1;
            active_buzzer = 0;
            printf("\r\n Welcome User 2 \n" );
            printf("\r User numer: 2 \n");
            output1=0;
            }
            if(3 == user_index3) {
                printf("\r\n Access granted: User 3  \n ");
            led_red = 1;
            active_buzzer = 0;
            printf("\r\n Welcome User 3 \n" );
            printf("\r User numer: 3 \n ");
            output1=0;
            }
            if(4 == user_index4) {
                printf("\r\n Access granted: User 4   \n ");
            led_red = 1;
            active_buzzer = 0;
            printf("\r\n Welcome User 4 \n" );
            printf("\r User numer: 4 \n");
            output1=0;
            }
            if(5 == user_index5) {
                printf("\r Access granted: User 5 \n ");
            led_red = 1;
            active_buzzer = 0;
            printf("\r\n Welcome User 5 \n " );
            printf("\r User numer: 5 \n");
            output1=0;
            }

            wait(1);
            active_buzzer = 0;
            beep = 25.0/100.0;
            led_red = 0;
            led_green=0;
            output1=1;
            wait(1);
      


        }
// indicates that an incorrect passwords was entered with leds and buzzer
        else {
            printf("\r\n \n Incorrect password \n \n Access denied!  \n \n  ");
            led_green = 1;
            led_red=0;
            wait(1);
            active_buzzer = 1;
             beep = 50.0/100.0;
            j=j+1;
            
            if(j==4){printf("\r\n \n TOO MANT ATTEMPTS, SYSTEM LOCKOUT  \n \n  ");
            led_green = 1;
            led_red=0;
            flag=1;
            wait(1);
            active_buzzer = 1;
             beep = 50.0/100.0;
               output1=1;
            wait(1);
             output1=0;
            wait(1);
             output1=1;
            wait(1);
             output1=0;
            wait(1);
             output1=1;
            wait(1);   
                                                                            }
            
                                                                    }
        
        beep = 0.0/100.0;
        led_green = 0;
            led_red=0;
    }
    
    
    
    
    
    } while(flag==0);
    
    
    
    
    
    
}

