

#include "mbed.h"
 
double  Xp = 0, Xi = 0, Xd = 0;         //Ausgabewerte der einzelnen Regler
double Xe = 0, XeAlt = 0, Xa = 0;       //Störgröße, Alte Störgröße, Ausgabewert
const double kp = 1, ki = 1, kd = 8;   //Verstärkungskonstanten für P, I und D
const double dt = 1;                    //Zeitkonstante in Sekunden
const double maxi = 1023, mini = 0;     //Max.- und Min.- Werte für Ausgabe
 
const double TestIn = 100;              //Künstlicher Sprung (lt. Vorgabe)
 
 
AnalogIn Input(p17);                    //Analoger Eingang
AnalogOut Output(p18);                  //Analoger Ausgang
 
 
int main(){
    printf("---  PID - Regler  ---\r\n");
    printf("---  Kundegraber   ---\r\n");
    
    wait(2);                            // Zwei Sekunden warten vor Start
    
    while(true){
        //Xe = Input.read();            // Analogeingeng Einlesen 0...1
        
        Xe = TestIn;                    // Eingang auf 100 (Künstlicher Sprung)
        
        Xp = kp * Xe;                   // P-Regler
        Xi = Xi + ki * Xe * dt;         // I-Regler
        Xd = kd * (Xe - XeAlt)/dt;      // D-Regler
         
        
        XeAlt = Xe;                     // Eingang für nächsten Zyklus merken
        
        Xa = Xp + Xi + Xd;              // PID Regler-Werte zusammenführen
        
        if (Xi > maxi) Xi = maxi;       // Begrenzung des I-Reglers auf Maximum
        if (Xa > maxi) Xa = maxi;       // Begrenzung des Ausgangs auf Maximum
        else if (Xa < mini) Xa = mini;  // Begrenzung des Ausgangs auf Minimum
        
        
        Output = Xa/1023;              // Ausgang in 0 bis 1 ausgeben (0...3,3V)
        
        // Serielle Ausgabe der einzelnen Regler-Werte
        printf("Xp = %4.1f, Xi = %4.1f, Xd = %4.1f \r\n",Xp,Xi,Xd);
        
        // Serielle Ausgabe des 10bit Ausganswertes 0...1023
        printf("   In: %4.1f     Out: %4.1f\r\n \r\n", Xe, Xa);
        
        wait(dt);                       // Warten mit Zeitkonstante
    }
}