//servo.h
#ifndef MBED_SERVO_H
#define MBED_SERVO_H

#include "mbed.h"

class Servo 
{

    public:
    // Create a servo object connected to the specified PwmOut pin
    Servo(PinName pin);

    //** Set the servo position, normalised to it's full range
    void write(float percent);

    //** Read the servo motors current position
    float read();

    //** Set the servo position
    void position(float degrees);

    //** Allows calibration of the range and angles for a particular servo
    void calibrate(float range = 0.0005, float degrees = 45.0);

    /** Shorthand for the write and read functions */
    Servo& operator= (float percent);
    Servo& operator= (Servo& rhs);
    operator float();

    protected:
    PwmOut _pwm;
    float _range;
    float _degrees;
    float _p;
};

#endif