// Steuerung des R-Servo mit Tasten

#include "mbed.h"
#include "servo.h"

DigitalIn Rechts(P0_15);
DigitalIn Links(P0_10);
DigitalIn RangePlus(P0_23);
DigitalIn RangeMinus(P1_16);

Servo myservo(P0_8); // p6

int main() 
{
    float range = 0.0005;
    float position = 0.5;

    while(1) 
    {
        if(Rechts)
        position = 0.0;
        if(Links)
        position = 1.0;
        if(Rechts && Links)
        {
            position = 0.5;
            wait_ms(100);
        }
        if(RangePlus)
        {
            range += 0.0001;
            wait_ms(100);
        }
        if(RangeMinus)
        {
            range -= 0.0001;
            wait_ms(100);
        }
        myservo.calibrate(range, 45.0);
        myservo = position;
        wait_ms(500);
    }
}