#include "mbed.h"

InterruptIn  SW1(p14);  // für den Test ist nur dieser erforderlich
InterruptIn  SW2(p15); 
InterruptIn  SW3(p12); 
InterruptIn  SW4(p16); 

BusOut Leds ( LED1 , LED2, LED3, LED4);


//Ticker flipper;             // Ticker für blinken der LED
//volatile int blinkCount=0;  // Volatile, damit es nicht auf unterschiedlichen Cores ausgeführt wird

enum State {ST_EIN=0, ST_AUS, ST_STOPP};
State state;

Timer myTimer;

int LedWert = 3, btnCount = 0; // bei LED steht 3 für den Startwert damit die ersten beiden LEDS gleich leuchten

bool pressed = false;

/*
void flip()                 // 
{
    blinkCount++;           // Variable die hochgezählt wird um die LED 2 mal blinken zu lassen
    Led4 = !Led4;           // umschalten der LED
}
*/
 
void rise(void)
{  
    wait_ms(100);           // Entprellung der Taste, bei mir 100ms da der Taster furchtbar prellt...
    pressed = true;         // Umschalten auf WAHR, es wurde gedrückt
}

bool CheckFlag() 
{
    if (pressed)            // Abfrage ob pressed WAHR ist
    {
        pressed=false;      // Rücksetzen wieder auf Status FALSCH
        return true;        // Rückgabe bei CheckFlag das WAHR ist
    }
    return false;           // Wenn nicht pressed Wahr ist wird CheckFlag als FALSCH zurück gegeben
}


void ST_Ein (void)
{

    printf("State: 1 (EIN)");       // Ausgabe auf der seriellen Console
    
//_______________entry____________________\\
    
//_______________do_______________________\\

   
             while(true) 
             {
        Leds = LedWert;
    
        if(CheckFlag()) 
        {
            btnCount++;
            if(btnCount >= 3)
            {
                btnCount = 0;
                LedWert++;
                state = ST_AUS;
            
//______________exit_______________________\\

            return;
            }
        }
   }
}


void ST_Aus (void)
{

    printf("State: 2 (AUS)");       // Ausgabe auf der seriellen Console
    
  
    
//_____________do______________\\

    while(true) 
    {
       
       Leds = 0;
    
        if(CheckFlag()) 
        {
            myTimer.reset();
            myTimer.start();
            while(1)
            {
                if ( myTimer.read() >=0.2)
                {
                    break;
                    }
                    else if (CheckFlag())
                    {
                        myTimer.stop();
                        state=ST_STOPP;
                        return;
                    }
                }
            state = ST_EIN;
            
//_______________exit______________\\
myTimer.stop();
            return;
            }
        }
}

void ST_Error (void)
{
    printf("State: ERROR!!!");
    return;
}

void ST_Stopp (void)
{
    printf("State: Wir sind am Ende :-P");
    Leds = 0;
    return;
}

void stateMachine()
{
    switch (state)
    {
    case ST_EIN: ST_Ein();  // Zustand 0, hier starten wir 
        break;
    case ST_AUS: ST_Aus();  // Zustand 1, Umschaltung
        break;
    case ST_STOPP : ST_Stopp(); // Zustand 2 und auch der letzte, hier ist Ende
        break;
    default: ST_Error();  // Für evtl. Fehler, die wir ja nicht haben ...
        break;
    }
}


 
int main()
{
    SW1.rise(&rise);      //.fall(&fall);
    Leds = 15;            // damit alle leuchten
    wait_ms(500);         // laut Angabe, eine verzögerung von 500ms
    
    state = ST_EIN;       // wir starten mit diesem Zustand
    while(true)
    {
        stateMachine(); 
    }
}

/* 
wurde zur Verfügung gestellt


class IsAnEvent : public InterruptIn {
        volatile int16_t _pressed;
        void _RisingISR(); 
    public:
        IsAnEvent() : InterruptIn(p14) {};
        IsAnEvent(PinName pin) : InterruptIn(pin) {
             rise(callback(this, &IsAnEvent::_RisingISR)); 
            _pressed=0; 
        };
        int CheckFlag();
        void InitIsr();
};

void IsAnEvent::InitIsr() { 
    rise(callback(this, &IsAnEvent::_RisingISR)); 
}

void IsAnEvent::_RisingISR() {
    wait_ms(50);
    if( read() )
        _pressed = true;
}
int IsAnEvent::CheckFlag() {
    if( _pressed ) { 
        _pressed = false; 
        return 1; 
    }
    return 0;
}
*/