#include "mbed.h"
#include <stdio.h>
#include <string.h>
 
#define TRENNZEICHEN "/"
#define ANZ_FELDER 5
// ---------------- Inherited Serial RS232 Event Class  --------------------------
const uint8_t STRMAX = 80;  
const char EOT = ';';
const char CRLF = '\n';
 
class SerialEventInh : public Serial {
        // Serial _pc;
        void _risingISR();
        char _str[STRMAX]; 
        volatile bool _strOkFlag;
        int _index;
 
    public:
        SerialEventInh() : Serial(USBTX, USBRX)                             // create the Serial on the pin specified to SwEvent
        {
            attach(callback(this, &SerialEventInh::pc_recv));               // attach DataReceive-function of this SerialEvent instance 
            _strOkFlag = false;
            _index=0;
        }
 
        SerialEventInh(PinName tx, PinName rx) : Serial(tx, rx) {           // create the Serial on the pin specified to SwEvent
            attach(callback(this, &SerialEventInh::pc_recv));               // attach DataReceive-function of this SerialEvent instance 
            _strOkFlag = false;
            _index=0;
 
        }
        void pc_recv();
        void getString(char st[]);
        int checkFlag();                                                    // must in do-condition (while(true)-loop) continuously interrogated
};
void SerialEventInh::getString(char st[]) {
    for( int i=0; i <= _index; i++)
        st[i] = _str[i];
    _index=0;
}
 
void SerialEventInh::pc_recv() {
    char c;
    while(readable()){
        c = getc();
        if((c != CRLF) && (_index < STRMAX)) {
            _str[_index++] = c;
        }
    }
    if(( c == EOT)) {                                                       // end: . string not empty
        if(_index >= 1) {
            _strOkFlag = true;
            _str[--_index] = 0; 
        }
    }
}
 
int SerialEventInh::checkFlag() {
    if( _strOkFlag ) {
        _strOkFlag = false; 
        return 1;
    }
    return 0;
}

class ParsSerial : public SerialEventInh
{
    public:
    ParsSerial(PinName tx, PinName rx) : public SerialEventInh(tx,rx)
    
    
    
    
    
};

void ParseFelder :: ParsSerial( char str[], char pFelder, int anz, char trenn[]){}

ParsSerial ps(USBTX, USBRX);
 
int main() 
{
    
    
    char str[STRMAX];
    char* pFelder[ANZ_FELDER];
 
    while(1) {
        if(ps.checkFlag()) {
            ps.getString(str);
            printf("String: %s\n", str);
            ps.ParseFelder(str, pFelder, ANZ_FELDER, TRENNZEICHEN);
            printf("Str: %s  %s  %s\r\n", pFelder[0], pFelder[1], pFelder[2]);
        }
    }