#include "mbed.h"
#include "C12832.h"

DigitalOut Led1(LED1, 0);   // 1. LED am MBED-Board
DigitalOut Led2(LED2, 0);   // 2. LED am MBED-Board
DigitalOut Led3(LED3, 0);   // 3. LED am MBED-Board
DigitalOut Led4(LED4, 0);   // 4. LED am MBED-Board
InterruptIn  SW1(p13);      // LEFT am MBED-Board
InterruptIn  SW1(p14);      // CENTER am MBED-Board
InterruptIn  SW2(p15);      // UP am MBED-Board
InterruptIn  SW3(p12);      // DOWN am MBED-Board
InterruptIn  SW4(p16);      // RIGHT am MBED-Board

Ticker flipper;             // Ticker für blinken der LED
volatile int blinkCount=0;  // Volatile, damit es nicht auf unterschiedlichen Cores ausgeführt wird


//______________ LCD ____________________________\\

C12832 lcd(p5, p7, p6, p8, p11);    // Definition der LCD-Pins

//_____________ meine Variablen _________________\\

enum State {ST_AUS=0, ST_EIN};
State state;

bool pressed = false;


// ______________Led blinken lassen______________\\

void flip()                 // 
{
    blinkCount++;           // Variable die hochgezählt wird um die LED 2 mal blinken zu lassen
    Led4 = !Led4;           // umschalten der LED
}

//************* EREIGNISSE ****************
 
void rise(void)
{  
    wait_ms(100);           // Entprellung der Taste, bei mir 100ms da der Taster furchtbar prellt...
    pressed = true;         // Umschalten auf WAHR, es wurde gedrückt
}

bool CheckFlag() 
{
    if (pressed)            // Abfrage ob pressed WAHR ist
    {
        pressed=false;      // Rücksetzen wieder auf Status FALSCH
        return true;        // Rückgabe bei CheckFlag das WAHR ist
    }
    return false;           // Wenn nicht pressed Wahr ist wird CheckFlag als FALSCH zurück gegeben
}

//************* STATES ****************

void ST_Aus (void)
{
//______________Status auf LCD und Serial_______________\\
    lcd.cls();              // löscht lcd (clear screen)
    lcd.locate(0,0);        // x-position, y-position (x: 0-128; y: 0-32)
    lcd.printf("State: 1 (Aus)");   //Ausgabe am Display
    printf("State: 1 (Aus)");       // Ausgabe auf der seriellen Console
    
//_______________entry____________________\\
    
//_______________do_______________________\\

    while(true) 
    {
        Led1 = 0;           // Led1 wird auf LOW gesetzt
        if(CheckFlag())     // Ist CheckFlag WAHR dann
        {
            state = ST_EIN; // Wechsel auf Status EIN
            
//______________exit_______________________\\

            return;
            }
        }
}

void ST_Ein (void)
{
    //Status auf LCD und Serial
    lcd.cls();      // löscht lcd (clear screen)
    lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
    lcd.printf("State: 2 (Ein)");
    printf("State: 2 (Ein)");
    
    
    // aufruf um die Led blinken zu lassen
    flipper.attach(&flip, 0.3); // the address of the function to be attached (flip) and the interval (2 seconds)
    
    while(true)
    {
        if ( blinkCount >= 4) break;
        }
        flipper.detach();
        blinkCount=0;
    
    /*
    // entry
    Led4 = 1;
    wait_ms(200);
    Led4 = 0;
    wait_ms(200);
    Led4 = 1;
    wait_ms(200);
    Led4 = 0;
    wait_ms(200);
    */
    // do
    while(true) {
        Led1 = 1;
    
        if(CheckFlag()) 
        {
            state = ST_AUS;
            
    // exit
            return;
            }
        }
}

void ST_Error (void)
{
    //Status auf LCD und Serial
    lcd.cls();      // löscht lcd (clear screen)
    lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
    lcd.printf("State: ERROR!!!");
    printf("State: ERROR!!!");
    return;
}

void stateMachine()
{
    switch (state)
    {
    case ST_AUS: ST_Aus();
        break;
    case ST_EIN: ST_Ein();
        break;
    default: ST_Error();  // sollte nicht auftreten :-)
        break;
    }
}


 
int main()
{
    SW1.rise(&rise);      //.fall(&fall);
    state = ST_AUS;
    while(true)
    {
        stateMachine(); 
    }
}