#include "mbed.h"

// Instanziierung mit:
/*
HexLeds hexleds(LED1, LED2, LED3, LED4);
 
// Aufruf der Methoden
main() {
   hexleds.eingabe()     // einlesen eines Integer-Wertes von der Tastatur mit scanf("%d", &ein);
   hexleds.ausgabe()     // ausgeben des Integer-Wertes der von der Tastatur eingegeben wurde
   hexleds.hexOut()      // Ausgabe des Wertes in Hex-Darstellung an den 4 Leds
   hexleds.printStatus() // Anzeigen ob Leds ein oder aus
}
*/


class HexLeds
{
    private:
        BusOut _ledbus;
        DigitalOut _pin0;
        DigitalOut _pin1;
        DigitalOut _pin2;
        DigitalOut _pin3;
        int _eingabe;
        
    public:
         HexLeds(PinName pin0, PinName pin1, PinName pin2, PinName pin3):
        _pin0(pin0), 
        _pin1(pin1), 
        _pin2(pin2), 
        _pin3(pin3), 
        _ledbus(pin0,pin1,pin2,pin3)
        
        {
            _pin0=0; 
            _pin1=0; 
            _pin2=0; 
            _pin3=0;
            _ledbus = 0;
        }
        
        void eingabe(void)
        {
            bool was = false;
            
            while(was == false)
            {
                scanf("%d", &_eingabe);
                if (_eingabe < 16)
                    was = true;
            }
        }
        void ausgabe(void)
        {
            printf("Der Dezimalwert: %d - Der Hexadezimalwert: 0x%X \n", _eingabe, _eingabe);
        }
        void hexOut(void)
        {
            _ledbus = _eingabe;
        }
        void printStatus(void)
        {                       // zum Auslesen entweder (*_pin0).read() oder _pin1->read()
            printf("LED1: %d - LED2: %d - LED3: %d - LED4: %d \n", _pin0.read(), _pin1.read(), _pin2.read(), _pin3.read());
        }
    
    
    
};

HexLeds hexleds(LED1,LED2,LED3,LED4);

//LaufLichtBalken lauflichtbalken(LED1, LED2, LED3, LED4);
//DigitalOut led(LED1);
/* MyLed myled1(LED1);
MyLed myled2(LED2);     // Instanzierung des Objects
MyLed myled3(LED3);
MyLed myled4(LED4);
MyLed myled5(p5);
*/



int main()
{
    
   hexleds.eingabe();     // einlesen eines Integer-Wertes von der Tastatur mit scanf("%d", &ein);
   hexleds.ausgabe();     // ausgeben des Integer-Wertes der von der Tastatur eingegeben wurde
   hexleds.hexOut();      // Ausgabe des Wertes in Hex-Darstellung an den 4 Leds
   hexleds.printStatus(); // Anzeigen ob Leds ein oder aus

}


