#include "mbed.h"

/********Beispiel 1*********************
ledOn()       // beide Leds einschalten
ledOff()      // beide Leds ausschalten
ledX()        // beide Leds gegengleich schalten
printStatus() // Anzeigen ob Leds ein oder aus
******************************/

      
/**********Beispiel 2***********************
 * //lauflicht() 
    D1  D2  D3  D4
    -   -   -   -       Ein Durchgang dauert 2 sec
    X   -   -   -
    -   X   -   - 
    -   -   X   -
    -   -   -   X
    -   -   -   -       X=ON  - = off
*********************************/

/***********Beispiel 3**********************
 * //lauflichtbalken()
    D1  D2  D3  D4
    -   -   -   -       Ein Durchgang dauert 2 sec
    X   -   -   -
    X   X   -   - 
    X   X   X   -
    X   X   X   X
    -   -   -   -
    X   X   X   X         X=ON  - = off
**********************************/

class LaufLichtBalken
{
    public:
        LaufLichtBalken(PinName pin, PinName pin2, PinName pin3, PinName pin4 ) : _pin(pin) , _pin2(pin2), _pin3(pin3), _pin4(pin4) // initialisierungsliste ( muss gleich heissen wie der Konstruktor )
        {
            _pin=0;                     // initalisierung mit 0
            _pin2=0;
            _pin2=0;
            _pin2=0;
        }
        
    

    void ledOff(void)
    {
        _pin=0;
        _pin2=0;
        _pin3=0;
        _pin4=0;
    }
    
    void ledOn1(void)
    {
    _pin=1;
    _pin2=0;
    _pin3=0;
    _pin4=0;
    }
    
    void ledOn2(void)
    {
    _pin=1;
    _pin2=1;
    _pin3=0;
    _pin4=0;
    }
    
    void ledOn3(void)
    {
    _pin=1;
    _pin2=1;
    _pin3=1;
    _pin4=0;
    }
    
    void ledOn4(void)
    {
    _pin=1;
    _pin2=1;
    _pin3=1;
    _pin4=1;
    }
    
    void printStatus(void)
    {
     printf("Status Read:\nLED1 is now %d\nLED2 is now %d\nLED1 is now %d\nLED1 is now %d\n\n", _pin.read(), _pin2.read(), _pin3.read(), _pin4.read()); 
    // printf("Read LED is now %d\n", _pin2.read()); 
    }
    private:
        DigitalOut _pin; // _steht im Namen für privat, am Anfang oder am ende
        DigitalOut _pin2; 
        DigitalOut _pin3; 
        DigitalOut _pin4; 
};


LaufLichtBalken lauflichtbalken(LED1, LED2, LED3, LED4);
//DigitalOut led(LED1);
/* MyLed myled1(LED1);
MyLed myled2(LED2);     // Instanzierung des Objects
MyLed myled3(LED3);
MyLed myled4(LED4);
MyLed myled5(p5);
*/



int main()
{
    while (1) 
    {
    
    
    lauflichtbalken.ledOff();      // beide Leds ausschalten
    lauflichtbalken.printStatus(); // Anzeigen ob Leds ein oder aus
    wait_ms(333);
    lauflichtbalken.ledOn1();       // beide Leds einschalten
    lauflichtbalken.printStatus(); // Anzeigen ob Leds ein oder aus
    wait_ms(333);
    lauflichtbalken.ledOn2();       // beide Leds einschalten
    lauflichtbalken.printStatus(); // Anzeigen ob Leds ein oder aus
    wait_ms(333);
    lauflichtbalken.ledOn3();       // beide Leds einschalten
    lauflichtbalken.printStatus(); // Anzeigen ob Leds ein oder aus
    wait_ms(333);
    lauflichtbalken.ledOn4();       // beide Leds einschalten
    lauflichtbalken.printStatus(); // Anzeigen ob Leds ein oder aus
    wait_ms(333);
    lauflichtbalken.ledOff();      // beide Leds ausschalten
    lauflichtbalken.printStatus(); // Anzeigen ob Leds ein oder aus
    wait_ms(333);
    lauflichtbalken.ledOn4();       // beide Leds einschalten
    lauflichtbalken.printStatus(); // Anzeigen ob Leds ein oder aus
    wait_ms(333);
    
    }
}


