#include "mbed.h"
 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

DigitalOut red(p23);
DigitalOut green(p24);
DigitalOut blue(p25);
 
class StopLight 
{
private:
    Timer t1;   //mein Timer
    EventQueue _queue;
    int _pending;
 
    enum state { RED, GREEN, YELLOW,GREENBLINK };
 
    // The _step function is a traditional FSM which enqueues transitions onto the event queue
    void _step(state transition) {
        switch (transition) {
            case RED:
                set_red();
                _pending = _queue.call_in(1000, this, &StopLight::_step, GREEN);
                break;
 
            case GREEN:
                set_green();
                _pending = _queue.call_in(1000, this, &StopLight::_step, GREENBLINK);
                break;
                
            case GREENBLINK:
                set_greenBlink();
                _pending = _queue.call_in(3000, this, &StopLight::_step, YELLOW);
                break;
 
            case YELLOW:
                set_yellow();
                _pending = _queue.call_in(500, this, &StopLight::_step, RED);
                break;
        }
    }
    
void set_red()
    {
        red = 0; green = 1; blue = 1;
    }
void set_green()
    {
        red = 1; green = 0; blue = 1;
         
    }
void set_greenBlink()
    {
        t1.start();    // ich starte meinen Timer
        //red = 1; green = 1; blue = 1;
        if(t1.read_ms()>200)    // erst wenn 10Hz
    {
        
        if(green=1)
        {
            red = 1; green = 1; blue = 1;
            }
        else
        {
            red = 1; green = 0; blue = 1;
            }
            t1.reset();     // ich resete meinen Timer
    }
        
        if ( green=0)
        green=1;
        else
        green=0;
    }
void set_yellow() 
    {
        red = 0; green = 0; blue = 1;
       
       /* 
        wait_ms(150);
        red = 1; green = 1; blue = 1;
        wait_ms(150);
        red = 0; green = 0; blue = 1;
        wait_ms(150);
        red = 1; green = 1; blue = 1;
        */
    }
public:
    // The fire function can immediately change states in the FSM
    void fire() 
    {
        _queue.cancel(_pending);
        _queue.call(this, &StopLight::_step, GREEN);
        _queue.dispatch();
    }
};
 
StopLight sl;
 
int main (void) 
{
    sl.fire();
    wait(osWaitForever);
}