#include "mbed.h"
 
DigitalOut led(LED1);
InterruptIn btn(p15);
 
EventQueue queue;   // create an event queue
 
void fall_handler() {
    // this now runs in the context of eventThread, instead of in the ISR
    //led = !led;   //-> IRQ Routine
    printf("Printf context %p\r\n", Thread::gettid());
}
 
void fall_handler_isr()
{
 led = !led; 
 queue.call(&fall_handler);
 printf("ISR context %p\r\n", Thread::gettid());    // sollte nicht hier stehen
 
 
 }
 
 
int main() {
    // create a thread that'll run the event queue's dispatch function
    Thread eventThread;
    eventThread.start(callback(&queue, &EventQueue::dispatch_forever));
    printf("Using Event Queue starting in context %p\r\n", Thread::gettid());
    
// wrap calls in queue.event to automatically defer to the queue's thread
    btn.fall(&fall_handler_isr);
   // btn.fall(queue.event(&fall_handler_isr));
    wait(osWaitForever);
}