// see: [[RTOS: Demonstration Setup]] 
// Trace ab 15:00
 
#include "mbed.h"
#include "C12832.h"
 
 C12832 lcd (p5, p7, p6, p8, p11);
 
class Rgb
{
private:
    DigitalOut _led;
 
public:
    Rgb(PinName ld) : _led(ld) { _led = 1;};  // Constructor
    
    void LedOn() {
        _led = 0;
    }
    void LedOff(){
        _led.write(1);
    }
};  
 
class HasA
{
private:
    DigitalOut _led;
 
public:
    HasA(PinName ld) : _led(ld) {};  // Constructor
    
    void LedOn() {
        _led = 1;
    }
    void LedOff(){
        _led.write(0);
    }
};  
 
void Delay_Nonsense(uint32_t * DelayCounter, uint32_t const * TargetCount)
{
    while(*DelayCounter <= *TargetCount)
    {
        *DelayCounter = *DelayCounter + 1;
    }
 
    *DelayCounter = 0;
}
 
//M3 r (p23); g (p24); b (p25);
/*
HasA Led1(LED1);
HasA Led2(LED2);
HasA Led3(LED3);
*/
Rgb Led1(p23);
Rgb Led2(p24);
Rgb Led3(p25);
 
//void Led1_Blink(void *pvParameters)
void Led1_Blink()       // red long
{
   const int xDelay = 500; 
   uint32_t BlueDelay = 0;
   const uint32_t TargetCount = 16000;
 
   for(;;) {    
       for(int i = 0; i < 10; i++) {        // randomnes
          wait_ms(xDelay);
       }
 
       {
           lcd.cls();
           lcd.locate(0,3);
           lcd.printf("Thread 1 RED LED blinks \r\nxxxxxxxx!");
           
           Led1.LedOn();
           Delay_Nonsense(&BlueDelay, &TargetCount);
           wait_ms(xDelay);
           Led1.LedOff();
           Delay_Nonsense(&BlueDelay, &TargetCount);
           wait_ms(xDelay);
       }
   }
}
 
void Led2_Blink()   // green
{
   const int xDelay = 250; 
   uint32_t BlueDelay = 0;
   const uint32_t TargetCount = 16000;
 
   for(;;) {
       for(int i = 0; i < 10; i++) {     // randomnes
          wait_ms(xDelay);
       }
       {
           lcd.cls();
           lcd.locate(0,3);
           lcd.printf("Thread 2 GREEN LED blinks \r\nxxxxxxxx!");
           
           Led2.LedOn();
           Delay_Nonsense(&BlueDelay, &TargetCount);
           wait_ms(xDelay);
           Led2.LedOff();
           Delay_Nonsense(&BlueDelay, &TargetCount);
           wait_ms(xDelay);
       }
   }
}
 
void Led3_Blink()   // blue very short
{
   const int xDelay = 100; 
   uint32_t BlueDelay = 0;
   const uint32_t TargetCount = 16000;
 
   for(;;) {
       for(int i = 0; i < 10; i++) {     // randomnes
          wait_ms(xDelay);
       }
       {
           lcd.cls();
           lcd.locate(0,3);
           lcd.printf("Thread 3 BLUE LED blinks \r\nxxxxxxxx!");
           
           
           Led3.LedOn();
           Delay_Nonsense(&BlueDelay, &TargetCount);
           wait_ms(xDelay);
           Led3.LedOff();
           Delay_Nonsense(&BlueDelay, &TargetCount);
           wait_ms(xDelay);
       }
   }
}
 
DigitalOut Led4(LED4);
volatile bool running = true;
 
// Callback function to pass arguments to params
void blink(DigitalOut *led) {
    osThreadSetPriority(osThreadGetId(), osPriorityIdle);
    while (running) {
        *led = !*led;
        wait(1);
    }
}
 
// https://docs.mbed.com/docs/mbed-os-api-reference/en/latest/APIs/tasks/rtos/#thread
 
Thread thread1;//(osPriorityNormal, 400, NULL); //DEFAULT_STACK_SIZE, NULL); die default stack size funktioniert manchmal nicht laut Hr. Pucher
// Thread thread1;
Thread thread2;
Thread thread3;
// parametrisierter Thread
Thread pthread; //(osPriorityHigh, 400, NULL);//DEFAULT_STACK_SIZE, NULL);
 
int main() {
    thread1.start(Led1_Blink);
    thread2.start(Led2_Blink);
    thread3.start(Led3_Blink); 
    // Start parametrisierter Thread mit Callback Funktion
    pthread.start(callback(blink, &Led4));
 
    osThreadSetPriority(osThreadGetId(), osPriorityIdle);   // osPriorityHigh, 
                                                        // osPriorityIdle
    Thread::yield();
    printf("Priority is %i\r\n", thread1.get_priority());
    Thread::wait(1);
 
    thread1.join();
    thread2.join();
    thread3.join();
    
    while(1) {
    }
    thread1.terminate();
}
 
        