#include "mbed.h"
 
 
 class SerialEvent
 {
    private:
     Serial _isr;                       // für serielles einlesen
     volatile int16_t _pressed;    // wegen multicore unterstützung
     void _risingISR();             // prototyping
     string _str;                      // str ist nur eine Variable, könnte auch zeichen heißen
     
    public:
     int checkFlag();
     void read(string& zeichen);
     
     SerialEvent(PinName tx, PinName rx): _isr(tx,rx)       //Konstruktor
     {
         _isr.attach(callback(this, &SerialEvent::_risingISR));
     }
    };
      
     void SerialEvent :: read(string& zeichen)
     {
         zeichen= _str;
     }
        
     
     void SerialEvent :: _risingISR()
     {
         _str = _isr.getc();
         _pressed=1;
     }
     
     int SerialEvent :: checkFlag ()
     {
         if(_pressed)
         {
         _pressed=0;
         return true;
         }
         else
         return false;
     }
         
         SerialEvent pc(USBTX, USBRX);  //pc ist wieder nur irgendeine Variable
  
  
  
  
  main()
  {
     
     char z;
     while(1)
     {
     if( pc.checkFlag())
     {
     pc.read(z);
     printf("Zeichen: %c\n",z);
     }
     }
     
     }   
     
     
     
     
/*
     
     
     public:
        SerialEvent 
            {
                
            }
            
    privat: 
    {
     
     }
     
};
// ---------------- Switch Event Class  --------------------------
class SwEvent 
{
        InterruptIn _isr;
        volatile int16_t _pressed;
        void _risingISR();
 
    public:
        SwEvent(PinName pin) : _isr(pin) {          // create the InterruptIn on the pin specified to SwEvent
            _isr.rise(callback(this, &SwEvent::_risingISR));  // attach ISR-function of this SwEvent instance 
            _pressed=0; 
        }
        int checkFlag();                            // must in do-condition (while(true)-loop) continuously interrogated
        void init();
};
// ---------------- Switch Event Class Methodes --------------------------
int SwEvent::checkFlag() 
{
    if( _pressed ) 
    {
        _pressed = 0; 
        return 1;
    }
    return 0;
}
 
void SwEvent::_risingISR() 
{            
    if( _isr.read() )
        _pressed = 1;
}
};
 
Counter counter(p14);
SwEvent swevent (p15);
 
int main() {
    while(1) {
        printf("Count so far: %d\n", counter.read());
        printf("true/false so far: %d\n", swevent.read());
        wait(2);
    }
}

*/