#include "mbed.h"
 
class SwEvent
{
 
public:
    SwEvent (PinName pin) : _pressed(pin)
    {
        _pressed.rise(callback(this, &SwEvent::checkFlag)); // attach increment function of this counter instance
    }
    void checkFlag()
    {
       _checkFlag = !_checkFlag ;
    }



    bool read() 
    {
        return _checkFlag;
    }

private:

    InterruptIn _pressed;
    volatile bool _checkFlag;
 
};
 
 
class Counter 
{
public:
    Counter(PinName pin) : _interrupt(pin) // create the InterruptIn on the pin specified to Counter
    {        
        _interrupt.rise(callback(this, &Counter::increment)); // attach increment function of this counter instance
    }
 
    void increment() 
    {
        _count++;
    }
 
    int read() 
    {
        return _count;
    }
 
private:
    InterruptIn _interrupt;
    volatile int _count;
};
 
Counter counter(p14);
SwEvent swevent (p15);
 
int main() {
    while(1) {
        printf("Count so far: %d\n", counter.read());
        printf("true/false so far: %d\n", swevent.read());
        wait(2);
    }
}