#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "MODSERIAL.h"

#define SEND_BUF_SIZE 4096

DigitalOut R(LED_RED);
DigitalOut G(LED_GREEN);
DigitalOut B(LED_BLUE);

MODSERIAL serial(USBTX, USBRX,4096); // tx, rx
EthernetInterface eth;
HTTPClient http;

char str[32000];
char str2[32000];

int main() {
    setbuf(stdout, NULL);
    eth.init();
    eth.connect();
    R=!R;G=!G;B=!B;
    wait(1);

    while(1){
        // Wait for Token on Serial and read to str
        // Light Blue
        B=!B;
        while(1){
               if(serial.readable()){
                    serial.scanf("%s",&str);
                    break;
                }
        }
        // Token Read, light Yellow
        R=!R;G=!G;B=!B;
        //printf(str);
        
        // Send token to Server
        HTTPMap map;
        HTTPText inText(str2, 32000);
        map.put("client_id", "a1b2c3");
        map.put("client_secret", "drickyoughurt");
        map.put("token_type_hint", "pop_token");
        map.put("token", str);
        
        int ret = http.post("https://kongsugar.de/introspection", map, &inText); 
        if (!ret)
        {
          // Unlock, Light Green 5s
          R=!R;wait(5);G=!G;
        }
        else
        {
          // Light Red 5s
          G=!G;wait(5);R=!R;
        }
        
        // Bugfix, nervous user send token multiple times!
        memset(&str[0], 0, sizeof(str));
        memset(&str2[0], 0, sizeof(str2));
        serial.rxBufferFlush();
    }
}
