#include "mbed.h"

float accel_x_g;
float accel_y_g;
float accel_z_g;

float gyro_x_rad;
float gyro_y_rad;
float gyro_z_rad;

// i2c device addresses
#define MPU6050_ADDRESS  (0x68<<1)   // adresse de MPU6050 avec AD0 = 0

// serial communication configuration
Serial pc(SERIAL_TX, SERIAL_RX);

I2C i2c(PB_9, PB_8);        // SDA et SCL
void mpu6050_read_sensors(void);


int main(void) {
// Configurations 

    char data_write[2];
    data_write[0] = 0x6B;
    data_write[1] = 0x00;
    i2c.write(MPU6050_ADDRESS, data_write, 2, 0);                               // res 107 : exit sleep
    data_write[0] = 0x19;
    data_write[1] = 109;
    i2c.write(MPU6050_ADDRESS, data_write, 2, 0);                               // res 25 : sample rate = 8kHz / 110 = 72.7Hz   
    data_write[0] = 0x1B;
    data_write[1] = 0x18;
    i2c.write(MPU6050_ADDRESS, data_write, 2, 0);                               // res 27 : gyro full scale = +/- 2000dps   
    data_write[0] = 0x1C;
    data_write[1] = 0x08;
    i2c.write(MPU6050_ADDRESS, data_write, 2, 0);                               // res 28 : accelerometer full scale = +/- 4g
    data_write[0] = 0x38;
    data_write[1] = 0x01;
    i2c.write(MPU6050_ADDRESS, data_write, 2, 0);                               // res 56 : enable INTA interrupt
    
    
    while(1)
    {
     mpu6050_read_sensors();
     wait(1);
    }

}

void mpu6050_read_sensors(void) {

    // read the sensor values
    int i;
    char data_write[2];
    char  data_read[20]; 
    int8_t rx_buffer[20];
    float temp_reel;

    data_write[0] = 0x41;//0x3B;
    i2c.write(MPU6050_ADDRESS,data_write, 1, 1); 
    i2c.read(MPU6050_ADDRESS,data_read,2,0);
    /*
    for(i = 0; i<1; i++)
    {
      rx_buffer[i] = data_read[i] - '0';
    }
  */
    
    
  //  i2c_read_registres(I2C1, MPU6050_ADDRESS, 20, 0x3B, rx_buffer);

    // extract the raw values
    int16_t  accel_x  = (int16_t)rx_buffer[0] << 8|(int16_t) rx_buffer[1];
    int16_t  accel_y  = rx_buffer[2]  << 8 | rx_buffer[3];
    int16_t  accel_z  = rx_buffer[4]  << 8 | rx_buffer[5];
    int16_t  mpu_temp = (int16_t)rx_buffer[6] << 8 | (int16_t)rx_buffer[7];
    int16_t  gyro_x   = rx_buffer[8]  << 8 | rx_buffer[9];
    int16_t  gyro_y   = rx_buffer[10] << 8 | rx_buffer[11];
    int16_t  gyro_z   = rx_buffer[12] << 8 | rx_buffer[13];
    
    temp_reel = mpu_temp/340 + 36.53; 

    // convert accelerometer readings into G's
     accel_x_g = accel_x / 8192.0f;
     accel_y_g = accel_y / 8192.0f;
     accel_z_g = accel_z / 8192.0f;
    // convert gyro readings into Radians per second
     gyro_x_rad = gyro_x / 939.650784f;
     gyro_y_rad = gyro_y / 939.650784f;
     gyro_z_rad = gyro_z / 939.650784f;
   
//   pc.printf("l'accel x = %d \r\n", accel_x );
 //  pc.printf("l'accel y= %f \r\n", accel_y );
 //  pc.printf("l'accel z = %f \r\n", accel_z );
 //    pc.printf("le buffer0 = %d, \r\n", rx_buffer[0]);
  //   pc.printf("le buffer1 = %d, \r\n", rx_buffer[1]);
  
      int16_t  temperature = (int16_t)data_read[0] << 8 | (int16_t)data_read[1];
      temp_reel = temperature/340 + 36.53; 
     
     pc.printf("la valeur T lit sur le registre = %X \r\n", temperature );
     pc.printf("la temperature T = %f \r\n", temp_reel );
     pc.printf("le buffer6 = %X, \r\n", data_read[0]);
     pc.printf("le buffer7 = %X, \r\n", data_read[1]);
}

