// UNAL - Procesadores
// Actividades Oct/2019 - JMP

#include "mbed.h"
#include "MMA8451Q.h" // Acc-Sensor

#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define POLLTIME 0.1 // Time in ms, how often the Acc-Sensor is read out

Serial pc(USBTX, USBRX); // Init serial

int main() {
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    
    while(1) {
        pc.printf("(X|Y|Z) - (%.2f|%.2f|%.2f)\r\n",abs(acc.getAccX()),abs(acc.getAccY()),abs(acc.getAccZ()));
        wait(POLLTIME);
    }
}