// UNAL - Procesadores
// Actividades Oct/2019 - JMP

#include "mbed.h"
#include "TSISensor.h" // Slider-Sensor

#define POLLTIME 0.1 // Time in ms, how often the Touch-Sensor is read out

void toggleWhite(); // Prototype for toggle-function

DigitalOut red(LED1); //red
DigitalOut green(LED2); //Green
DigitalOut blue(LED3); //Blue

Serial pc(USBTX, USBRX); // Init serial

int main() {
    TSISensor touchSensor; // Init TSISensor-struct
    int pollCtr = 0;
    int tmpSliderPerc = 0;
    
    // Reset all LEDs to off (LEDs are low-active)
    red = 1;
    green = 1;
    blue = 1;
    
    while(1) {
        if(pollCtr >= (1/POLLTIME)) { // Toggle LED after 1s (every "1/POLLTIME"-loops)
            toggleWhite(); // Call function which toggles LED
            pollCtr = 0; // Reset counter
        }
        
        if((tmpSliderPerc < (int)(touchSensor.readPercentage()*100.0) - 3) || (tmpSliderPerc > (int)(touchSensor.readPercentage()*100.0) + 3)) { // If the Slider-Value has changed while "noise" (+/- 3%) is ignored, print actual value
            tmpSliderPerc = (int)(touchSensor.readPercentage()*100.0);
            pc.printf("Touchsensor: %d%%\r\n",tmpSliderPerc);
        }
        
        wait(POLLTIME);
        pollCtr++;
    }
}

void toggleWhite() { // Functions toggles all three RGB-LEDs (white light on/off)
        red = !red;
        blue = !blue;
        green = !green;
}