// Copyright 2020 Georgia Tech.  All rights reserved.
// The materials provided by the instructor in this course are for
// the use of the students currently enrolled in the course.
// Copyrighted course materials may not be further disseminated.
// This file must not be made publicly available anywhere.

#include "graphics.h"

#include "globals.h"

#define YELLOW 0xFFFF00
#define BROWN  0xD2691E
#define DIRT   BROWN

const char head[121] = {
    'G','G','G','G','G','G','G','G','G','G','G',
    'G','G','G','G','G','G','G','G','G','G','G',
    'G','R','R','R','G','G','R','R','R','G','G',
    'G','R','R','R','G','G','R','R','R','G','G',
    'G','R','R','R','G','G','R','R','R','G','G',
    'G','G','G','G','G','G','G','G','G','G','G',
    'G','R','R','R','G','G','R','R','R','G','G',
    'G','R','R','R','G','G','R','R','R','G','G',
    'G','R','R','R','G','G','R','R','R','G','G',
    'G','G','G','G','G','G','G','G','G','G','G',
    'G','G','G','G','G','G','G','G','G','G','G',
    };
 
const char tail[121] = {
    'G','G','G','G','G','G','G','G','G','G','G',
    'G','G','G','G','G','G','G','G','G','G','G',
    'G','Y','Y','Y','G','G','G','Y','Y','Y','G',
    'G','Y','Y','Y','G','G','G','Y','Y','Y','G',
    'G','Y','Y','Y','G','G','G','Y','Y','Y','G',
    'G','G','G','G','G','G','G','G','G','G','G',
    'G','G','G','G','G','G','G','G','G','G','G',
    'G','Y','Y','Y','G','G','Y','Y','Y','G','G',
    'G','Y','Y','Y','G','G','Y','Y','Y','G','G',
    'G','Y','Y','Y','G','G','Y','Y','Y','G','G',
    'G','G','G','G','G','G','G','G','G','G','G',
    }; 
    
const char poison[121] = {
    'Y','3','3','3','3','3','3','3','3','3','Y',
    '3','Y','3','3','3','3','3','3','3','Y','3',
    '3','3','Y','3','3','3','3','3','Y','3','3',
    '3','3','3','Y','3','3','3','Y','3','3','3',
    '3','3','3','3','Y','3','Y','3','3','3','3',
    '3','3','3','3','3','Y','3','3','3','3','3',
    '3','3','3','3','Y','3','Y','3','3','3','3',
    '3','3','3','Y','3','3','3','Y','3','3','3',
    '3','3','Y','3','3','3','3','3','Y','3','3',
    '3','Y','3','3','3','3','3','3','3','Y','3',
    'Y','3','3','3','3','3','3','3','3','3','Y',
    }; 
    
const char speedup[121] = {
    '3','3','3','3','3','G','3','3','3','3','3',
    '3','3','3','3','G','3','G','3','3','3','3',
    '3','3','3','G','3','3','3','G','3','3','3',
    '3','3','G','3','3','3','3','3','G','3','3',
    '3','G','3','3','3','3','3','3','3','G','3',
    'G','3','3','3','3','3','3','3','3','3','G',
    '3','3','3','3','3','G','3','3','3','3','3',
    '3','3','3','3','G','3','G','3','3','3','3',
    '3','3','3','G','3','3','3','G','3','3','3',
    '3','3','G','3','3','3','3','3','G','3','3',
    '3','G','3','3','3','3','3','3','3','G','3',
    }; 
    
const char slowdown[121] = {
    'G','3','3','3','3','3','3','3','3','3','G',
    '3','G','3','3','3','3','3','3','3','G','3',
    '3','3','G','3','3','3','3','3','G','3','3',
    '3','3','3','G','3','3','3','G','3','3','3',
    '3','3','3','3','G','3','G','3','3','3','3',
    '3','3','3','3','3','G','3','3','3','3','3',
    'G','3','3','3','3','3','3','3','3','3','G',
    '3','G','3','3','3','3','3','3','3','G','3',
    '3','3','G','3','3','3','3','3','G','3','3',
    '3','3','3','G','3','3','3','G','3','3','3',
    '3','3','3','3','G','3','G','3','3','3','3',
    }; 
    
const char decrease_length[121] = {
    '3','3','3','3','3','3','3','3','3','3','3',
    '3','3','3','3','Y','Y','3','3','3','3','3',
    '3','3','3','Y','3','3','Y','Y','Y','3','3',
    '3','3','3','Y','3','3','Y','3','3','3','3',
    '3','3','3','3','Y','Y','3','3','3','3','3',
    '3','3','3','3','3','3','3','3','3','3','3',
    '3','3','3','3','3','3','3','3','3','3','3',
    '3','3','3','3','3','3','3','3','3','3','3',
    '3','3','3','3','3','3','3','3','3','3','3',
    '3','3','3','3','3','3','3','3','3','3','3',
    '3','3','3','3','3','3','3','3','3','3','3',
    }; 
    
const char random[121] = {
    '5','5','5','5','5','G','5','5','5','5','5',
    '5','5','5','5','G','5','G','5','5','5','5',
    '5','5','5','G','5','5','5','G','5','5','5',
    '5','5','5','5','5','5','5','G','5','5','5',
    '5','5','5','5','5','5','5','G','5','5','5',
    '5','5','5','5','5','5','G','5','5','5','5',
    '5','5','5','5','5','G','5','5','5','5','5',
    '5','5','5','5','5','G','5','5','5','5','5',
    '5','5','5','5','5','G','5','5','5','5','5',
    '5','5','5','5','5','5','5','5','5','5','5',
    '5','5','5','5','5','G','5','5','5','5','5',
    }; 
    
const char moving[121] = {
    'G','G','G','G','R','R','G','G','G','G','G',
    'G','G','G','G','R','R','R','G','G','G','G',
    'G','R','R','R','R','R','R','R','R','G','G',
    'G','R','R','R','G','G','R','R','R','G','G',
    'G','R','R','R','G','G','R','R','R','G','G',
    'G','R','R','G','G','G','G','G','R','G','G',
    'G','R','R','R','R','R','R','R','R','G','G',
    'G','R','R','R','R','G','R','R','R','G','G',
    'G','G','R','R','R','G','R','R','R','G','G',
    'G','G','G','R','R','R','R','R','G','G','G',
    'G','G','G','G','R','R','R','G','G','G','G',
    }; 
    
const char invinc[121] = {
    '3','3','3','3','3','R','3','3','3','3','3',
    '3','3','3','3','3','R','3','3','3','3','3',
    '3','3','3','3','3','R','3','3','3','3','3',
    '3','3','3','3','3','R','3','3','3','3','3',
    '3','3','3','3','3','R','3','3','3','3','3',
    'R','R','R','R','R','R','R','R','R','R','R',
    '3','3','3','3','3','R','3','3','3','3','3',
    '3','3','3','3','3','R','3','3','3','3','3',
    '3','3','3','3','3','R','3','3','3','3','3',
    '3','3','3','3','3','R','3','3','3','3','3',
    '3','3','3','3','3','R','3','3','3','3','3',
    }; 
const char goodie[121] = {
    'B','B','B','B','B','B','B','B','B','B','B',
    'B','B','B','G','G','B','D','B','B','B','B',
    'B','B','B','B','G','D','B','B','B','B','B',
    'B','B','R','B','B','R','R','R','B','B','B',
    'B','R','W','W','R','R','R','R','R','R','B',
    'B','R','W','R','R','R','R','R','R','R','B',
    'B','R','R','R','R','R','R','R','R','R','B',
    'B','R','R','R','R','R','R','R','R','R','B',
    'B','B','R','R','R','R','R','R','R','B','B',
    'B','B','B','B','B','B','B','B','B','B','B',
    };   
    
const char brick [121] = {
    '5','5','5','5','3','3','3','3','3','3','3',
    '5','S','S','S','B','5','5','3','3','B','B',
    '5','5','5','5','B','B','3','3','3','3','3',
    '5','S','S','S','B','5','5','3','3','B','B',
    '5','5','5','5','B','B','3','3','3','3','3',
    '5','S','S','S','B','5','5','3','3','B','B',
    '5','5','5','5','B','B','3','3','3','3','3',
    '5','S','S','S','B','5','5','3','3','B','B',
    '5','5','5','5','B','B','3','3','3','3','3',
    '5','S','S','S','B','5','5','3','3','B','B',
    '5','5','5','5','B','B','3','3','3','3','3',
    };
    
const char plant [121] = {
    'B','B','B','B','B','B','B','B','B','B','B',
    'B','B','B','B','B','B','B','B','B','B','B',
    'B','B','B','B','B','B','B','B','B','B','B',
    'B','B','B','B','B','B','B','B','B','B','B',
    'B','B','B','G','B','G','B','G','G','B','B',
    'B','B','G','G','G','G','G','G','G','G','B',
    'B','G','G','G','G','G','G','G','G','G','B',
    'G','G','G','G','G','G','G','G','G','B','B',
    'B','G','G','G','G','G','G','G','G','G','B',
    'G','G','G','G','G','G','G','G','G','G','B',
    'G','G','G','G','G','G','G','G','G','G','G',
    };
    
const char inclength [121] = {
    'B','B','B','B','B','B','B','B','B','B','B',
    'B','B','B','G','G','B','D','B','B','B','B',
    'B','B','B','B','G','D','B','B','B','B','B',
    'B','B','R','B','B','R','R','R','G','B','B',
    'B','G','W','W','R','R','R','R','R','R','B',
    'B','R','W','R','G','G','R','R','R','R','B',
    'B','R','R','R','G','G','R','G','G','R','B',
    'B','R','R','G','R','R','R','G','G','R','B',
    'B','B','R','R','R','R','R','R','R','B','B',
    'B','B','B','B','B','B','B','B','B','B','B',
    };
void draw_nothing(int u, int v)
{
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
}

void draw_img(int u, int v, const char* img)
{
    int colors[11*11];
    for (int i = 0; i < 11*11; i++)
    {
        if (img[i] == 'R') colors[i] = RED;
        else if (img[i] == 'Y') colors[i] = 0xFFFF00; // Yellow
        else if (img[i] == 'G') colors[i] = GREEN;
        else if (img[i] == 'D') colors[i] = 0xD2691E; // "Dirt"
        else if (img[i] == '5') colors[i] = LGREY; // 50% grey
        else if (img[i] == '3') colors[i] = DGREY;
        else colors[i] = BLACK;
    }
    uLCD.BLIT(u, v, 11, 11, colors);
    wait_us(250); // Recovery time!
}

void draw_wall(int u, int v)
{
    draw_img(u,v, brick);
//    uLCD.filled_rectangle(u, v, u+10, v+10, LGREY);
}

void draw_plant(int u, int v)
{
    draw_img(u,v, plant);
//  uLCD.filled_rectangle(u, v, u+10, v+10, GREEN);
}

void draw_goodie(int u, int v)
{
    draw_img(u,v, goodie);
//uLCD.filled_rectangle(u, v, u+10, v+10, 0xD2691E); //DIRT
}

void draw_snake_body(int u, int v)
{
    uLCD.filled_rectangle(u, v, u+10, v+10, GREEN);
}

void draw_snake_head(int u, int v)
{
     //May need to design a snake head sprite
     //Tile still need to be designed on paper
    
    uLCD.filled_rectangle(u, v, u+10, v+10, GREEN);
    draw_img(u,v, head);
    
}

void draw_snake_tail(int u, int v)
{
     //May need to design a snake tail sprite
     //Tile still need to be designed on paper
    
    uLCD.filled_rectangle(u, v, u+10, v+10, GREEN);
    draw_img(u,v, tail); 
}

void draw_poison(int u, int v) {
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
    draw_img(u, v, poison);
}

void draw_speedup(int u, int v) {
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
    draw_img(u, v, speedup);
}

void draw_slowdown(int u, int v) {
    draw_img(u, v, slowdown);
}

void draw_decrease_length(int u, int v) {
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
    draw_img(u, v, decrease_length);
}

void draw_random(int u, int v) {
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
    draw_img(u, v, random);
}

void draw_moving(int u, int v) {
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
    draw_img(u, v, moving);
}

void draw_invinc(int u, int v) {
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
    draw_img(u, v, invinc);
}

void draw_inclength(int u, int v) {
//uLCD.filled_rectangle(u, v, u+10, v+10, RED);
    draw_img(u, v, inclength);
}

void draw_welcome(int difficulty, int full) {
    if (full) {
        uLCD.text_bold(ON);
        uLCD.text_string("SNAKE GAME", 4, 2, FONT_7X8, RED);
        uLCD.text_string("Project 2.2 ", 2, 4, FONT_7X8, GREEN);
        uLCD.text_string("Cong Vu", 2, 5, FONT_7X8, GREEN);
        uLCD.text_string("Button 1: START",1,7,FONT_7X8, GREEN);
        uLCD.text_string("Button 2: LEVEL",1,8, FONT_7X8, GREEN);

    }

    uLCD.locate(1, 11);
    switch (difficulty) {
        case 0:
            uLCD.printf("Level: EASY");
            break;
        case 1:
            uLCD.printf("Level: MED ");
            break;
        case 2:
            uLCD.printf("Level: HARD");
            break;
        default:
            return;
    }
}
