// Damon Hill - 14234098 - 159.270
// Assignment 4 - Serial and Steppers

#include "mbed.h"

RawSerial pc(PA_2, PA_3);       // setup serial pins

class Stepper {
private:
    BusOut stepperMagnets;      // stepper pins output  
    int delay;          // delay between switching magnets (in ms)
    int direction;      // direction of motor (1 or 3)
    bool on;            // true-motor on, false-motor off
    Ticker t;           // ticker timer
public:
    Stepper(PinName p0, PinName p1, PinName p2, PinName p3, int d):
        stepperMagnets(p0, p1, p2, p3) {        // setup stepper pins
        if (d < 4)      // set delay
            delay = 4;
        else delay = d;
        direction = 1;      // set direction
        on = false;      
    }
    void run(void);     // declear functions
    void stop(void);
    void setDelay(int d);
    void toggleDirection(void);
    void toggleOn(void);
};

void Stepper::run(void) {
    static int currentMagnet = 0;       // variable that keeps it value when between iterations 
            stepperMagnets = (1 << currentMagnet);      // shift the currrent pulse
            currentMagnet = (currentMagnet + direction)%4;      // get the next pulse depending on direction
}

void Stepper::stop(void) {
    stepperMagnets = 0;     // turn all pins off
}

void Stepper::setDelay(int d) {
    if (d < 4)      // if the delay is too short
        delay = 4;      // set it to the min of 4ms
    else delay = d;     // else set delay
    if (on == true)     // if the stepper is on
        t.attach_us(this, &Stepper::run, 1000*delay);       // start the ticker with the new delay   
}

void Stepper::toggleDirection(void) {
    if (direction == 1)
        direction = 3;      // shifting by 3 reverses direction
    else direction = 1;
}

void Stepper::toggleOn(void) {
    if (on == false) {      // if stepper is not running 
        on = true;      // turn it on
        t.attach_us(this, &Stepper::run, 1000*delay);       // start the ticker with the delay 
    }
    else {
        on = false;     // turn it off
        t.detach();     // stop the ticker running the motor
        Stepper::stop();        // turn off all magnets
    }
}
    

int main() {
    Stepper myStepper(D10, D9, D7, D6, 4);      // setup stepper pins
    char serialIn[5];       // serial buffer
    unsigned int stringLen = 0;     // length of buffer
    
    pc.puts("===[Serial Stepper Control]===\r\n");      // serial intro 
    pc.puts("s-ON/OFF\n");
    pc.puts("t-change direction\n");
    pc.puts("d-set delay\n");
    
    while (1) {
        if (pc.readable()) {        // if something is inputted via serial
            char c = pc.getc();     // get the char
            pc.putc(c);     // echo it back
            serialIn[stringLen] = c;        // store it in the buffer
            stringLen ++;       // increment buffer length
            if (c == '\n' or stringLen == 5) {      // if a command has been entered
                if (serialIn[0] == 's') {      
                    pc.puts("Stepper toggled\n");       // toggle stepper on and off
                    myStepper.toggleOn();
                }
                else if (serialIn[0] == 't') {
                    pc.puts("Direction change\n");      // change stepper direction
                    myStepper.toggleDirection();
                }
                else if (serialIn[0] == 'd') {
                    pc.puts("Delay set\n");     // set delay
                    if (stringLen == 4) {       // if delay is less than 10
                        myStepper.setDelay(serialIn[2]-'0');    // do this to change char to int
                    }
                    else {      // if delay is 10 or greater
                        myStepper.setDelay(((serialIn[2]-'0')*10)+(serialIn[3]-'0'));        // do this to change char to int
                    }
                }
                else {
                    pc.puts("Invalid command\n");
                }
                stringLen = 0; // reset buffer
            }
        }
    }
}