// Damon Hill - 14234098 - 159.270
// Assignment 3 - Counters and LCD

#include "mbed.h"
#define LCD_DATA 1
#define LCD_INSTRUCTION 0

static void lcdSetRS(int mode);         // LCD functions 
static void lcdPulseEN(void);           
void lcdCommand(unsigned char command);     
void lcdPutChar(unsigned char c);      
void lcdString(char *s);              
int waitButton(unsigned int n);     // wait for button press or timeout function
void bin(void);     // binary counter function
void dec(void);     // decimal counter function
void hex(void);     // hexidecimal counter function
                                                                   
DigitalOut lcdD4(A2), lcdD5(A3), lcdD6(A4), lcdD7(A5);     // LCD outputs
DigitalOut lcdEN(A1), lcdRS(A0);
DigitalIn button (USER_BUTTON);     // button input

Timer t;

int main()
{
    lcdEN.write(0); //-- GPIO_WriteBit(GPIOC, LCD_EN, Bit_RESET);
    wait_us(15000); //-- delay for >15msec second after power on
    lcdCommand(0x28); // 4bit mode, dual line
    lcdCommand(0x01); //-- display clear
    wait_us(2000); // 2msec delay for screen to react
    lcdCommand(0x06); //-- cursor increments
    lcdCommand(0x0c); //-- display on, cursor off
    
    unsigned short int b = 0;       // variable for wait function output, 1 if button was pressed within time

while(1) {      // two second count loop
    lcdString("Binary");
    b = waitButton(2000);       // waits for 2 sec
    if (b == 1) {   // if button is pressed within time
        bin();      // count in binary
        }
    lcdString("Decimal");
    b = waitButton(2000);
    if (b == 1) {
        dec();
        }
    lcdString("Hexideicmal");
    b = waitButton(2000);
     if (b == 1) {
        hex();
        }
    }
}

void lcdString(char *s)  // from serial slides
{
    lcdCommand(0x01);       // clear the screen
    wait_ms(2);
    
    register unsigned short int i = 0;
    while (s[i] != '\0') {      // go through all char until it reaches the end null char 
        lcdPutChar(s[i]);       // send individually
        i++;                    // do next one
    }   
}

int waitButton(unsigned int n) 
{
    t.reset();          // reset timer
    if (n > 0) {
        t.start();      // if the time is not 0, start the timer
        }

    while (button == 0) {       // Waits for user to release the button before program continues
        }        

    while (t.read_ms() <= n) {
        if (button == 0) {          // if button is pressed
            t.stop();       // stop timer
            return(1);      // return 1, indicating button pressed within the time elapsed
        }
        wait_ms(10);        // wait a little bit 
    }
    t.stop();       // stop timer
    return(0);      // return 0, indicating NO button pressed within the time elapsed
}

void bin() 
{
    unsigned int i,n,c,f;       // initilize all local var
    
    for (i = 0; i < 16; i++) {      // creates a 0-15 count loop 
        lcdCommand(0x01);       // clear the screen
        wait_ms(2);
        c = 8;          // MSB decimal value
        n = i;          // temp variable to edit the count number
        f = 0;          // restart bit counter
        while (f < 4) {     // for the 4 bits
            if (n >= c) {       // if the count is equal or more than the current bit (power of two)
                lcdPutChar('1');        // print 1
                n = n-c;        // minus the power from the count
            }
            else {
                lcdPutChar('0');        // else print a 0
            }
            c = c/2;        // get next power of 2
            f++;        // do next bit
            }
        waitButton(0);      // wait forever till a button is pressed
    }
}
    
void dec() 
{
    unsigned short int i;

    for (i = 0; i < 16; i++) {
        lcdCommand(0x01);       // clear the screen
        wait_ms(2);   
        if (i > 9) {        // for count greater than 9
            lcdPutChar('1');        // print 1 (for the 10s)
            lcdPutChar(i-10+ '0');      // print 1s value. 
            }
        else {
            lcdPutChar(i + '0');        // ASCII '0' + an integer, will give the ASCII value of an integer from 0-9  
            }
        waitButton(0);      // wait forever till a button is pressed 
    }
}
    
void hex() 
{
    unsigned short int i;
    
    for (i = 0; i < 16; i++) {
        lcdCommand(0x01);       // clear the screen
        wait_ms(2);
        if (i > 9) {        // for count greater than 9
            lcdPutChar(i+7+ '0');       // get the ASCII value for A-F
            }
        else {
            lcdPutChar(i + '0');
            }
        waitButton(0);      // wait forever till a button is pressed 
    }
}


//====[Almost unchanged sample code from lecture slides]======
//     ||       ||      ||
//     \/       \/      \/
static void lcdSetRS(int mode)
{
    lcdRS.write(mode);
}
static void lcdPulseEN(void)
{
    lcdEN.write(1);
    wait_us(1); //-- enable pulse must be >450ns
    lcdEN.write(0);
    wait_us(1);
}

void lcdCommand(unsigned char command)
{
    lcdSetRS(LCD_INSTRUCTION);
    lcdD4.write((command>>4) & 0x01);
    lcdD5.write((command>>5) & 0x01);
    lcdD6.write((command>>6) & 0x01);
    lcdD7.write((command>>7) & 0x01);
    lcdPulseEN(); //-- this can't be too slow or it will time out
    lcdD4.write(command & 0x01);
    lcdD5.write((command>>1) & 0x01);
    lcdD6.write((command>>2) & 0x01);
    lcdD7.write((command>>3) & 0x01);
    lcdPulseEN();
    wait_us(37); //-- let it work on the data
}

void lcdPutChar(unsigned char c)
{
    lcdSetRS(LCD_DATA);
    lcdD4.write((c>>4) & 0x01);
    lcdD5.write((c>>5) & 0x01);
    lcdD6.write((c>>6) & 0x01);
    lcdD7.write((c>>7) & 0x01);
    lcdPulseEN(); //-- this can't be too slow or it will time out
    lcdD4.write(c & 0x01);
    lcdD5.write((c>>1) & 0x01);
    lcdD6.write((c>>2) & 0x01);
    lcdD7.write((c>>3) & 0x01);
    lcdPulseEN();
    wait_us(37); //-- let it work on the data
}


    
