#ifndef THERMISTOR_H
#define THERMISTOR_H
///
/// @mainpage Thermistor Temperature library
///
/// This is a Thermistor to Temerature conversion library 
///
/// Much thanks to @Adafruit for this tutorial:
/// https://learn.adafruit.com/thermistor/using-a-thermistor
///
/// The 100K Thermistor is configured with a 4.7k series resistor 
/// tied to vcc (3.3v)  like this:
///
///    +3.3v
///      |
///      \
///      /  4.7k series resistor
///      \
///      /
///      |
///      .-----------O To Anlog pin on FRDM board
///      |
///      \
///      /
///  Thermistor  100k Nominal
///      \
///      /
///      |
///     ---
///     GND
///  
///
/// @author Michael J. Ball
///  unix_guru at hotmail.com
///  @unix_guru on Twitter
///  March 2016
/// 
/// @code 
/// #include "mbed.h"
/// #include "Thermistor.h"
///    
/// Serial pc(USBTX, USBRX);
/// 
/// Thermistor bed(PTB10);
/// Thermistor extruder(PTB11);
/// 
/// int main()
/// {
///     pc.baud(115200);    
///     pc.printf("\r\nThermistor Test - Build " __DATE__ " " __TIME__ "\r\n");
///   
///     while(1) {  
///        pc.printf("Bed Temperature %f *C\r\n",bed.get_temperature()); 
///        wait(.5); 
///        pc.printf("Extruder Temperature %f *C\r\n",extruder.get_temperature()); 
///       wait(.5); 
///     }
/// }

/// ...
/// @endcode
///
/// @license
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///    http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///


#include "mbed.h"


#define THERMISTORNOMINAL 10000      // 100k default 
// temp. for nominal resistance (almost always 25 C)
#define TEMPERATURENOMINAL 25
// The beta coefficient of the thermistor (usually 3000-4000)
#define BCOEFFICIENT 3950
// the value of the 'other' resistor
#define SERIESRESISTOR 4700
  

class Thermistor {
public:
    Thermistor(PinName pin);  
    /** Receives a PinName variable.
     * @param pin mbed pin to which the thermistor is connected
     */


    float get_temperature();
    /**  This is the workhorse routine that calculates the temperature
     *   using the Steinhart-Hart equation for thermistors
     *   https://en.wikipedia.org/wiki/Steinhart%E2%80%93Hart_equation
     */
    void init();                                    // Set default Steinhart-Hart values
    void set_ThermistorNominal(float thermnom);     // Change the thermistors nominal resistance
    void set_TemperatureNominal(float tempnom);     // Change the thermistors nominal temperature
    void set_BCoefficient(float bcoefficient);      // Change the thermistors BCoefficient
    void set_SeriesResistor(float resistor);        // Change the value of the series resistor
 
private:
    AnalogIn _pin;
    float ThermistorNominal;
    float TemperatureNominal;
    float BCoefficient;
    float SeriesResistor;
};
 
#endif 
